/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.LogHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class Module {
    static final HashMap<ResourceLocation, Module> modules = new HashMap();
    private ForgeConfigSpec.ConfigValue<Boolean> enabledConfig;
    ForgeConfigSpec.Builder configBuilder;
    private boolean enabled;
    private boolean canBeDisabled;
    private final ResourceLocation id;
    private final String name;
    private String description = "";
    private static final Map<Class<? extends Feature>, Feature> loadedFeatures = new HashMap<Class<? extends Feature>, Feature>();
    private final Map<Class<? extends Feature>, Feature> features = new HashMap<Class<? extends Feature>, Feature>();
    static final Object _lock = new Object();
    private static final Type LOAD_FEATURE_TYPE = Type.getType(LoadFeature.class);

    Module(ForgeConfigSpec.Builder configBuilder, String id, String name) {
        this.id = new ResourceLocation(id);
        this.name = name;
        this.enabled = true;
        this.canBeDisabled = true;
        this.configBuilder = configBuilder;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::readConfig);
    }

    public void setConfigBuilder(ForgeConfigSpec.Builder builder) {
        if (this.configBuilder == null) {
            this.configBuilder = builder;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<Class<? extends Feature>, Feature> getFeatures() {
        return this.features;
    }

    public void loadConfig() {
        this.enabledConfig = this.canBeDisabled ? (!this.description.equals("") ? this.configBuilder.comment(this.description).define("Enable %s".formatted(this.name), this.enabled) : this.configBuilder.define("Enable %s".formatted(this.name), this.enabled)) : null;
    }

    public void readConfig(ModConfigEvent event) {
        this.enabled = this.canBeDisabled ? (Boolean)this.enabledConfig.get() : true;
        this.features.forEach((clazz, feature) -> feature.readConfig(event));
    }

    public void pushConfig() {
        if (this.canBeDisabled) {
            if (this.description.equals("")) {
                this.configBuilder.push(this.getName());
            } else {
                this.configBuilder.comment(this.description).push(this.getName());
            }
        }
    }

    public void popConfig() {
        if (this.canBeDisabled) {
            this.configBuilder.pop();
        }
    }

    public static void loadFeatures(String modId, ClassLoader classLoader) {
        ArrayList<Module> moduleToLoad = new ArrayList<Module>();
        ModFileScanData modFileScanData = ModList.get().getModFileById(modId).getFile().getScanResult();
        modFileScanData.getAnnotations().stream().filter(annotationData -> LOAD_FEATURE_TYPE.equals((Object)annotationData.annotationType())).sorted(Comparator.comparing(d -> d.getClass().getName())).forEach(annotationData -> {
            try {
                Class<?> clazz;
                Type type = annotationData.clazz();
                Class<?> featureClazz = clazz = Class.forName(type.getClassName(), false, classLoader);
                LogHelper.info("Found InsaneLib Feature class " + type.getClassName(), new Object[0]);
                Map annotationDataMap = annotationData.annotationData();
                String moduleString = (String)annotationDataMap.get("module");
                ResourceLocation moduleId = new ResourceLocation(moduleString);
                Module module = modules.get(moduleId);
                boolean enabledByDefault = true;
                if (annotationDataMap.containsKey("enabledByDefault")) {
                    enabledByDefault = (Boolean)annotationDataMap.get("enabledByDefault");
                }
                boolean canBeDisabled = true;
                if (annotationDataMap.containsKey("canBeDisabled")) {
                    canBeDisabled = (Boolean)annotationDataMap.get("canBeDisabled");
                }
                Feature feature = (Feature)clazz.getDeclaredConstructor(Module.class, Boolean.TYPE, Boolean.TYPE).newInstance(module, enabledByDefault, canBeDisabled);
                module.features.put(featureClazz, feature);
                loadedFeatures.put(featureClazz, feature);
                if (!moduleToLoad.contains(module)) {
                    moduleToLoad.add(module);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load Module %s".formatted(annotationData), e);
            }
        });
        moduleToLoad.forEach(m -> {
            m.pushConfig();
            m.getFeatures().forEach((clazz, feature) -> feature.loadConfig());
            m.popConfig();
        });
    }

    public static Map<Class<? extends Feature>, Feature> getAllLoadedFeatures() {
        return loadedFeatures;
    }

    public static Feature getFeature(Class<? extends Feature> featureClazz) {
        return loadedFeatures.get(featureClazz);
    }

    public static class Builder {
        private final Module module;

        public Builder(ForgeConfigSpec.Builder configBuilder, String id, String name) {
            this.module = new Module(configBuilder, id, name);
        }

        public static Builder create(ForgeConfigSpec.Builder configBuilder, String id, String name) {
            return new Builder(configBuilder, id, name);
        }

        public Builder setDescription(String description) {
            this.module.description = description;
            return this;
        }

        public Builder canBeDisabled(boolean canBeDisabled) {
            this.module.canBeDisabled = canBeDisabled;
            return this;
        }

        public Builder enabledByDefault(boolean enabledByDefault) {
            this.module.enabled = enabledByDefault;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Module build() {
            this.module.loadConfig();
            Object object = _lock;
            synchronized (object) {
                modules.putIfAbsent(this.module.id, this.module);
            }
            return this.module;
        }
    }
}

