/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.shieldsplus.world.item;

import insane96mcp.shieldsplus.render.ShieldBlockEntityWithoutLevelRenderer;
import insane96mcp.shieldsplus.setup.SPEnchantments;
import insane96mcp.shieldsplus.setup.client.ClientMaterials;
import insane96mcp.shieldsplus.world.item.SPShieldMaterial;
import insane96mcp.shieldsplus.world.item.enchantment.ShieldReflectionEnchantment;
import insane96mcp.shieldsplus.world.item.enchantment.ShieldReinforcedEnchantment;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPShieldItem
extends ShieldItem {
    public static final EnchantmentCategory SHIELD = EnchantmentCategory.create((String)"shield", s -> s instanceof ShieldItem);
    public static final ResourceLocation BLOCKING = new ResourceLocation("minecraft:blocking");
    public final SPShieldMaterial material;
    public ClientMaterials clientMaterials;
    public Double blockingDamageOverride = null;

    public SPShieldItem(SPShieldMaterial material, Item.Properties p_43089_) {
        super(p_43089_);
        this.material = material;
    }

    public double getBlockedDamage() {
        if (this.blockingDamageOverride != null) {
            return this.blockingDamageOverride;
        }
        return this.material.damageBlocked;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ShieldBlockEntityWithoutLevelRenderer.instance;
            }
        });
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.material.enchantmentValue;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        SPShieldItem.addDamageBlockedText(itemStack, components, this.getBlockedDamage());
    }

    public static void addDamageBlockedText(ItemStack itemStack, List<Component> components, double blockedDamage) {
        int reinforced = itemStack.getEnchantmentLevel((Enchantment)SPEnchantments.REINFORCED.get());
        float finalBlockedDamage = (float)(blockedDamage + ShieldReinforcedEnchantment.getDamageBlocked(reinforced));
        int reflection = itemStack.getEnchantmentLevel((Enchantment)SPEnchantments.REFLECTION.get());
        float reflectedDamage = ShieldReflectionEnchantment.getReflectedDamage(reflection);
        components.add((Component)Component.m_237110_((String)"shieldsplus:damage_blocked", (Object[])new Object[]{new DecimalFormat("#.#").format(finalBlockedDamage)}).m_130940_(ChatFormatting.BLUE));
        if (reflection > 0) {
            components.add((Component)Component.m_237110_((String)"shieldsplus:damage_reflected", (Object[])new Object[]{new DecimalFormat("#.#").format(reflectedDamage * 100.0f)}).m_130940_(ChatFormatting.BLUE));
            components.add((Component)Component.m_237110_((String)"shieldsplus:capped_damage_reflected", (Object[])new Object[]{new DecimalFormat("#.#").format(ShieldReflectionEnchantment.getCappedReflectedDamage(reflection))}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean m_6832_(@NotNull ItemStack repaired, @NotNull ItemStack repairingMaterial) {
        if (this.material.repairItem != null) {
            return repairingMaterial.m_150930_((Item)this.material.repairItem.m_13971_());
        }
        return repairingMaterial.m_204117_(this.material.repairTag);
    }

    public void tryCacheClientMaterials() {
        if (this.clientMaterials == null) {
            this.clientMaterials = new ClientMaterials(new Material(Sheets.f_110738_, new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)this).m_135827_(), "entity/shield/%s_shield_nopattern".formatted(this.material.materialName))), new Material(Sheets.f_110738_, new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)this).m_135827_(), "entity/shield/%s_shield".formatted(this.material.materialName))));
        }
    }

    public Material getClientMaterial(boolean hasBanner) {
        this.tryCacheClientMaterials();
        return hasBanner ? this.clientMaterials.patternMaterial() : this.clientMaterials.noPatternMaterial();
    }
}

