/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.shieldsplus.world.item.enchantment;

import insane96mcp.shieldsplus.setup.SPEnchantments;
import insane96mcp.shieldsplus.world.item.SPShieldItem;
import insane96mcp.shieldsplus.world.item.enchantment.ShieldAblazeEnchantment;
import insane96mcp.shieldsplus.world.item.enchantment.ShieldRecoilEnchantment;
import insane96mcp.shieldsplus.world.item.enchantment.ShieldReflectionEnchantment;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ShieldBashEnchantment
extends Enchantment {
    public static final String SHIELD_BASHING = "shieldsplus:shield_bashing";
    public static final String SHIELD_BASHING_LEVEL = "shieldsplus:shield_bashing_level";
    public static final String CHARGE_UP_TIMER = "shieldsplus:charge_up_timer";

    public ShieldBashEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, SPShieldItem.SHIELD, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
    }

    public int m_6183_(int level) {
        return 25;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 22;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_5975_(@NotNull Enchantment enchantment) {
        return !(enchantment instanceof ShieldReflectionEnchantment) && !(enchantment instanceof ShieldRecoilEnchantment) && super.m_5975_(enchantment);
    }

    public static double getForce(byte level) {
        return 3.0 + 0.5 * (double)(level - 1);
    }

    public static void onTick(Player player) {
        byte shieldBash = (byte)player.m_21211_().getEnchantmentLevel((Enchantment)SPEnchantments.SHIELD_BASH.get());
        ShieldBashEnchantment.cooldownTickChargeUpTimer(player);
        if (player.m_21254_() && ShieldBashEnchantment.getBashingTimer(player) <= 0 && shieldBash > 0) {
            if (ShieldBashEnchantment.getChargeUpTimer(player) < 30) {
                ShieldBashEnchantment.incrementChargeUpTimer(player);
                if (ShieldBashEnchantment.getChargeUpTimer(player) >= 30) {
                    player.m_5496_(SoundEvents.f_12346_, 1.0f, 1.65f);
                }
            } else if (player.m_6047_() && player.m_20096_()) {
                ShieldBashEnchantment.setBashingTimer(player, (byte)12);
                ShieldBashEnchantment.setBashingLevel(player, shieldBash);
                float x = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                float z = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                player.m_5496_(SoundEvents.f_12346_, 1.0f, 1.3f);
                player.m_20256_(player.m_20184_().m_82520_((double)x * ShieldBashEnchantment.getForce(shieldBash), 0.45, (double)z * ShieldBashEnchantment.getForce(shieldBash)));
                for (int i = 0; i < 50; ++i) {
                    player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_() + Mth.m_216263_((RandomSource)player.m_217043_(), (double)-0.5, (double)0.5), player.m_20186_() + Mth.m_216263_((RandomSource)player.m_217043_(), (double)-0.5, (double)0.5) + 0.9, player.m_20189_() + Mth.m_216263_((RandomSource)player.m_217043_(), (double)-0.5, (double)0.5), 0.1, 0.0, 0.1);
                }
                ShieldBashEnchantment.putChargeUpTimerOnCooldown(player);
            }
        } else if (ShieldBashEnchantment.getChargeUpTimer(player) > 0) {
            ShieldBashEnchantment.setChargeUpTimer(player, (byte)0);
        }
        if (ShieldBashEnchantment.getBashingTimer(player) > 0) {
            ShieldBashEnchantment.setBashingTimer(player, (byte)(ShieldBashEnchantment.getBashingTimer(player) - 1));
            if (player.m_21254_()) {
                ShieldBashEnchantment.damageAndKnockback(player, ShieldBashEnchantment.getBashingLevel(player));
            }
            if (ShieldBashEnchantment.getBashingTimer(player) <= 0) {
                ShieldBashEnchantment.setBashingLevel(player, (byte)0);
            }
        }
    }

    public static byte getChargeUpTimer(Player player) {
        return player.getPersistentData().m_128445_(CHARGE_UP_TIMER);
    }

    public static void setChargeUpTimer(Player player, byte timer) {
        player.getPersistentData().m_128344_(CHARGE_UP_TIMER, timer);
    }

    public static void cooldownTickChargeUpTimer(Player player) {
        if (ShieldBashEnchantment.getChargeUpTimer(player) < 0) {
            ShieldBashEnchantment.incrementChargeUpTimer(player);
        }
    }

    public static void incrementChargeUpTimer(Player player) {
        ShieldBashEnchantment.setChargeUpTimer(player, (byte)(ShieldBashEnchantment.getChargeUpTimer(player) + 1));
    }

    public static void putChargeUpTimerOnCooldown(Player player) {
        ShieldBashEnchantment.setChargeUpTimer(player, (byte)-30);
    }

    public static byte getBashingTimer(Player player) {
        return player.getPersistentData().m_128445_(SHIELD_BASHING);
    }

    public static void setBashingTimer(Player player, byte timer) {
        player.getPersistentData().m_128344_(SHIELD_BASHING, timer);
    }

    public static byte getBashingLevel(Player player) {
        return player.getPersistentData().m_128445_(SHIELD_BASHING_LEVEL);
    }

    public static void setBashingLevel(Player player, byte level) {
        player.getPersistentData().m_128344_(SHIELD_BASHING_LEVEL, level);
    }

    public static void damageAndKnockback(Player player, int level) {
        AABB aabb = player.m_20191_().m_82377_(0.6, 0.2, 0.6);
        List entities = player.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> entity != player);
        for (LivingEntity entity2 : entities) {
            if (entity2.m_21224_() || entity2.f_19802_ > 10) continue;
            entity2.m_147240_(1.0 + 0.4 * (double)level, player.m_20185_() - entity2.m_20185_(), player.m_20189_() - entity2.m_20189_());
            if (!entity2.m_6469_(player.m_269291_().m_269075_(player), (float)(3 + 3 * level))) continue;
            ShieldAblazeEnchantment.apply((LivingEntity)player, (Entity)entity2);
            player.m_5496_(SoundEvents.f_12346_, 1.0f, 0.5f);
        }
    }
}

