/*
 * Decompiled with CFR 0.152.
 */
package net.sprvlln.steveswasteland3.fluid.types;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class RadWaterFluidType
extends FluidType {
    public RadWaterFluidType() {
        super(FluidType.Properties.create().fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).canHydrate(true).viscosity(500).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("steves_wasteland3:blocks/radwaterstill");
            private static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("steves_wasteland3:blocks/radwaterflow");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public int getTintColor() {
                return -13083194;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
                return BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos) | 0xFF000000;
            }
        });
    }
}

