/*
 * Decompiled with CFR 0.152.
 */
package net.sprvlln.steveswasteland.entity;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreakBlockGoal;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.sprvlln.steveswasteland.SteveswastelandModElements;
import net.sprvlln.steveswasteland.block.BadshroomBushBlock;
import net.sprvlln.steveswasteland.entity.renderer.BighornBabyRenderer;
import net.sprvlln.steveswasteland.procedures.BabyBighornEntityDiesProcedure;
import net.sprvlln.steveswasteland.procedures.BighornBabyOnEntityTickUpdateProcedure;
import net.sprvlln.steveswasteland.procedures.BighornBabyOnInitialEntitySpawnProcedure;

@SteveswastelandModElements.ModElement.Tag
public class BighornBabyEntity
extends SteveswastelandModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(1.0f, 1.4f).func_206830_a("bighorn_baby").setRegistryName("bighorn_baby");

    public BighornBabyEntity(SteveswastelandModElements instance) {
        super(instance, 60);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new BighornBabyRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("steveswasteland:dirty_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:dead_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:harmful_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:aftermath").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:toxic_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:red_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:hard_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:tundra_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:aftermath").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 10, 1, 2));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    public static class CustomEntity
    extends AnimalEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 10;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
            this.field_70714_bg.func_75776_a(2, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 10.0f, 5.0f));
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(6, (Goal)new BreakBlockGoal(BadshroomBushBlock.block, (CreatureEntity)this, 1.0, 3));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public double func_70042_X() {
            return super.func_70042_X() + 0.4;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151082_bd));
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.mule.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.mule.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.mule.death"));
        }

        public void func_70645_a(DamageSource source) {
            super.func_70645_a(source);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Entity sourceentity = source.func_76346_g();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            BabyBighornEntityDiesProcedure.executeProcedure($_dependencies);
        }

        public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT tag) {
            ILivingEntityData retval = super.func_213386_a(world, difficulty, reason, livingdata, tag);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            BighornBabyOnInitialEntitySpawnProcedure.executeProcedure($_dependencies);
            return retval;
        }

        public void func_70030_z() {
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            BighornBabyOnEntityTickUpdateProcedure.executeProcedure($_dependencies);
        }

        public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
            CustomEntity retval = (CustomEntity)entity.func_200721_a((World)serverWorld);
            retval.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(new BlockPos((Vector3i)retval.func_233580_cy_())), SpawnReason.BREEDING, null, null);
            return retval;
        }

        public boolean func_70877_b(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return false;
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 15.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 3.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

