/*
 * Decompiled with CFR 0.152.
 */
package net.sprvlln.steveswasteland.entity;

import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.sprvlln.steveswasteland.SteveswastelandModElements;
import net.sprvlln.steveswasteland.entity.BighornEntity;
import net.sprvlln.steveswasteland.entity.renderer.ZombieSpitterRenderer;
import net.sprvlln.steveswasteland.itemgroup.StevesWastelandItemGroup;

@SteveswastelandModElements.ModElement.Tag
public class ZombieSpitterEntity
extends SteveswastelandModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.8f).func_206830_a("zombie_spitter").setRegistryName("zombie_spitter");
    public static final EntityType arrow = (EntityType)EntityType.Builder.func_220322_a(ArrowCustomEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).setCustomClientFactory(ArrowCustomEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("entitybulletzombie_spitter").setRegistryName("entitybulletzombie_spitter");

    public ZombieSpitterEntity(SteveswastelandModElements instance) {
        super(instance, 37);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ZombieSpitterRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
        this.elements.entities.add(() -> arrow);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -10040320, -10040320, new Item.Properties().func_200916_a(StevesWastelandItemGroup.tab)).setRegistryName("zombie_spitter_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("steveswasteland:aftermath").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:dead_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:dirty_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:hard_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:harmful_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:red_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:toxic_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("steveswasteland:tundra_wastes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 60, 1, 4));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    @OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
    private static class ArrowCustomEntity
    extends AbstractArrowEntity
    implements IRendersAsItem {
        public ArrowCustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            super(arrow, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, World world) {
            super(type, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, double x, double y, double z, World world) {
            super(type, x, y, z, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, LivingEntity entity, World world) {
            super(type, entity, world);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184548_a(LivingEntity livingEntity) {
            super.func_184548_a(livingEntity);
            livingEntity.func_85034_r(livingEntity.func_85035_bI() - 1);
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_184543_l() {
            return new ItemStack((IItemProvider)Items.field_151081_bc);
        }

        protected ItemStack func_184550_j() {
            return new ItemStack((IItemProvider)Items.field_151081_bc);
        }
    }

    public static class CustomEntity
    extends MonsterEntity
    implements IRangedAttackMob {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 1;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BighornEntity.CustomEntity.class, false, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BighornEntity.CustomEntity.class, false, false));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VillagerEntity.class, false, false));
            this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BighornEntity.CustomEntity.class, false, false));
            this.field_70714_bg.func_75776_a(5, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.5f));
            this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70715_bh.func_75776_a(8, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(10, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal(this, 1.25, 20, 10.0f){

                public boolean func_75253_b() {
                    return this.func_75250_a();
                }
            });
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151078_bh));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("steveswasteland:spitter_step")), 0.15f, 1.0f);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("steveswasteland:spitter_hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("steveswasteland:spitter_death"));
        }

        public void func_82196_d(LivingEntity target, float flval) {
            ArrowCustomEntity entityarrow = new ArrowCustomEntity((EntityType<? extends ArrowCustomEntity>)arrow, (LivingEntity)this, this.field_70170_p);
            double d0 = target.func_226278_cu_() + (double)target.func_70047_e() - 1.1;
            double d1 = target.func_226277_ct_() - this.func_226277_ct_();
            double d3 = target.func_226281_cx_() - this.func_226281_cx_();
            entityarrow.func_70186_c(d1, d0 - entityarrow.func_226278_cu_() + (double)MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * (double)0.2f, d3, 1.6f, 12.0f);
            this.field_70170_p.func_217376_c((Entity)entityarrow);
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 10.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 3.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

