/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.api.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;
import net.silentchaos512.tokenenchanter.setup.ModTags;

public class TokenEnchantingRecipeBuilder {
    private ResourceLocation name;
    private final Item result;
    private final int count;
    private final int levelCost;
    private Ingredient token;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();
    private final Map<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>();
    private int infuseLevels = 0;

    protected TokenEnchantingRecipeBuilder(IItemProvider result, int count, int levelCost) {
        this.result = result.func_199767_j();
        this.count = count;
        this.levelCost = levelCost;
    }

    public static TokenEnchantingRecipeBuilder builder(IItemProvider result, int count, int levelCost) {
        return new TokenEnchantingRecipeBuilder(result, count, levelCost);
    }

    public static TokenEnchantingRecipeBuilder enchantedTokenBuilder(Enchantment enchantment, int enchantmentLevel, int count, int levelCost) {
        return TokenEnchantingRecipeBuilder.builder(ModItems.ENCHANTED_TOKEN, count, levelCost).enchantment(enchantment, enchantmentLevel).token((ITag<Item>)ModTags.Items.TOKENS_GOLD);
    }

    public TokenEnchantingRecipeBuilder name(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public TokenEnchantingRecipeBuilder enchantment(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public TokenEnchantingRecipeBuilder infuseLevels(int levels) {
        if (!new ItemStack((IItemProvider)this.result).getCapability(XpStorageCapability.INSTANCE).isPresent()) {
            throw new IllegalStateException("Item '" + NameUtils.from((IForgeRegistryEntry)this.result) + "' has no XP storage capability");
        }
        this.infuseLevels = levels;
        return this;
    }

    public TokenEnchantingRecipeBuilder token(IItemProvider item) {
        return this.token(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public TokenEnchantingRecipeBuilder token(ITag<Item> tag) {
        return this.token(Ingredient.func_199805_a(tag));
    }

    public TokenEnchantingRecipeBuilder token(Ingredient ingredient) {
        this.token = ingredient;
        return this;
    }

    public TokenEnchantingRecipeBuilder addIngredient(IItemProvider item, int count) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), count);
    }

    public TokenEnchantingRecipeBuilder addIngredient(ITag<Item> tag, int count) {
        return this.addIngredient(Ingredient.func_199805_a(tag), count);
    }

    public TokenEnchantingRecipeBuilder addIngredient(Ingredient ingredient, int count) {
        this.ingredients.put(ingredient, count);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation itemId = NameUtils.from((IForgeRegistryEntry)this.result);
        ResourceLocation id = this.name == null ? itemId : this.name;
        this.build(consumer, id);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final TokenEnchantingRecipeBuilder builder;

        public Result(ResourceLocation id, TokenEnchantingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("level_cost", (Number)this.builder.levelCost);
            JsonObject ingredients = new JsonObject();
            ingredients.add("token", this.builder.token.func_200304_c());
            JsonArray others = new JsonArray();
            this.builder.ingredients.forEach((ing, count) -> {
                JsonObject j = ing.func_200304_c().getAsJsonObject();
                j.addProperty("count", (Number)count);
                others.add((JsonElement)j);
            });
            ingredients.add("others", (JsonElement)others);
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.from((IForgeRegistryEntry)this.builder.result).toString());
            if (this.builder.count > 1) {
                result.addProperty("count", (Number)this.builder.count);
            }
            if (!this.builder.enchantments.isEmpty()) {
                JsonArray array = new JsonArray();
                this.builder.enchantments.forEach((enchantment, level) -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("name", NameUtils.from((IForgeRegistryEntry)enchantment).toString());
                    obj.addProperty("level", (Number)level);
                    array.add((JsonElement)obj);
                });
                result.add("enchantments", (JsonElement)array);
            }
            if (this.builder.infuseLevels > 0) {
                result.addProperty("infuse_levels", (Number)this.builder.infuseLevels);
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipes.TOKEN_ENCHANTING.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

