/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.block.tokenenchanter;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterContainer;
import net.silentchaos512.tokenenchanter.crafting.recipe.TokenEnchanterRecipe;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;
import net.silentchaos512.tokenenchanter.setup.ModTileEntities;

public class TokenEnchanterTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    public static final int PROCESS_TIME = 50;
    private static final int INVENTORY_SIZE = 9;
    private static final int[] SLOTS_INPUT = IntStream.range(1, 8).toArray();
    private static final int[] SLOTS_OUTPUT = new int[]{8};
    private static final int[] SLOTS_ALL = IntStream.range(0, 9).toArray();
    private int progress;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TokenEnchanterTileEntity.this.progress;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TokenEnchanterTileEntity.this.progress = value;
                }
            }
        }

        public int func_221478_a() {
            return 1;
        }
    };

    public TokenEnchanterTileEntity() {
        super((TileEntityType)ModTileEntities.TOKEN_ENCHANTER.get(), 9);
    }

    @Nullable
    private TokenEnchanterRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.TOKEN_ENCHANTING_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
    }

    private ItemStack getCraftingResult(TokenEnchanterRecipe recipe) {
        return recipe.func_77572_b((IInventory)this);
    }

    private void consumeIngredients(TokenEnchanterRecipe recipe) {
        recipe.consumeIngredients((IInventory)this);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        TokenEnchanterRecipe recipe = this.getRecipe();
        if (recipe != null && this.canMachineRun(recipe)) {
            ++this.progress;
            if (this.progress >= 50) {
                this.storeResultItem(this.getCraftingResult(recipe));
                this.consumeIngredients(recipe);
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
    }

    private boolean canMachineRun(TokenEnchanterRecipe recipe) {
        return this.field_145850_b != null && recipe.func_77569_a((IInventory)this, this.field_145850_b) && this.hasRoomForOutputItem(this.getCraftingResult(recipe));
    }

    private boolean hasRoomForOutputItem(ItemStack stack) {
        return TokenEnchanterTileEntity.canItemsStack(stack, this.func_70301_a(8));
    }

    private static boolean canItemsStack(ItemStack a, ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) && a.func_190916_E() + b.func_190916_E() <= a.func_77976_d();
    }

    private void storeResultItem(ItemStack stack) {
        ItemStack output = this.func_70301_a(8);
        if (TokenEnchanterTileEntity.canItemsStack(stack, output)) {
            if (output.func_190926_b()) {
                this.func_70299_a(8, stack);
            } else {
                output.func_190920_e(output.func_190916_E() + stack.func_190916_E());
            }
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.tokenenchanter.token_enchanter");
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new TokenEnchanterContainer(id, playerInventory, this, this.fields);
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case UP: {
                return SLOTS_INPUT;
            }
            case DOWN: {
                return SLOTS_ALL;
            }
        }
        return SLOTS_ALL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 8;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
            return xp.canDrain();
        }
        return index < 8;
    }
}

