/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.compat.jei;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterContainer;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterScreen;
import net.silentchaos512.tokenenchanter.compat.jei.TokenEnchantingRecipeCategoryJei;
import net.silentchaos512.tokenenchanter.item.EnchantedTokenItem;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;

@JeiPlugin
public class TokenEnchanterJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = TokenMod.getId("plugin");
    static final ResourceLocation TOKEN_ENCHANTING = TokenMod.getId("category/token_enchanting");

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new TokenEnchantingRecipeCategoryJei(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        reg.addRecipes(TokenEnchanterJeiPlugin.getRecipesOfType(ModRecipes.TOKEN_ENCHANTING_TYPE), TOKEN_ENCHANTING);
    }

    private static List<IRecipe<?>> getRecipesOfType(IRecipeType<?> recipeType) {
        World world = (World)Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        return world.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == recipeType).collect(Collectors.toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack(ModBlocks.TOKEN_ENCHANTER), new ResourceLocation[]{TOKEN_ENCHANTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(TokenEnchanterScreen.class, 102, 32, 24, 23, new ResourceLocation[]{TOKEN_ENCHANTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(TokenEnchanterContainer.class, TOKEN_ENCHANTING, 0, 8, 9, 36);
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)ModItems.ENCHANTED_TOKEN.get(), stack -> {
            Enchantment enchantment = EnchantedTokenItem.getSingleEnchantment(stack);
            return enchantment != null ? enchantment.func_77320_a() : "none";
        });
    }
}

