/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterScreen;
import net.silentchaos512.tokenenchanter.compat.jei.TokenEnchanterJeiPlugin;
import net.silentchaos512.tokenenchanter.crafting.recipe.TokenEnchanterRecipe;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.util.TextUtil;

public class TokenEnchantingRecipeCategoryJei
implements IRecipeCategory<TokenEnchanterRecipe> {
    private static final int GUI_START_X = 21;
    private static final int GUI_START_Y = 24;
    private static final int GUI_WIDTH = 134;
    private static final int GUI_HEIGHT = 50;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public TokenEnchantingRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TokenEnchanterScreen.TEXTURE, 21, 24, 134, 50);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.TOKEN_ENCHANTER));
        this.localizedName = I18n.func_135052_a((String)"category.tokenenchanter.token_enchanting", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return TokenEnchanterJeiPlugin.TOKEN_ENCHANTING;
    }

    public Class<? extends TokenEnchanterRecipe> getRecipeClass() {
        return TokenEnchanterRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(TokenEnchanterRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        inputs.add(recipe.getToken());
        inputs.addAll(recipe.getIngredientMap().keySet());
        ingredients.setInputIngredients(inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, TokenEnchanterRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 30);
        itemStacks.init(1, true, 0, 10);
        itemStacks.init(2, true, 26, 0);
        itemStacks.init(3, true, 44, 0);
        itemStacks.init(4, true, 62, 0);
        itemStacks.init(5, true, 26, 18);
        itemStacks.init(6, true, 44, 18);
        itemStacks.init(7, true, 62, 18);
        itemStacks.init(8, false, 111, 10);
        itemStacks.set(0, TokenEnchantingRecipeCategoryJei.getXpCrystals(recipe));
        itemStacks.set(1, Arrays.asList(recipe.getToken().func_193365_a()));
        ArrayList inputs = new ArrayList();
        recipe.getIngredientMap().forEach((ingredient, count) -> {
            List<ItemStack> list = Arrays.asList(ingredient.func_193365_a());
            list.forEach(stack -> stack.func_190920_e(count.intValue()));
            inputs.add(list);
        });
        for (int i = 0; i < inputs.size(); ++i) {
            itemStacks.set(i + 2, (List)inputs.get(i));
        }
        itemStacks.set(8, recipe.getResult());
    }

    private static List<ItemStack> getXpCrystals(TokenEnchanterRecipe recipe) {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(stack -> {
            IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
            return xp.canDrain() && xp.getCapacity() >= recipe.getLevelCost();
        }).map(TokenEnchantingRecipeCategoryJei::getFullCrystal).collect(Collectors.toList());
    }

    private static ItemStack getFullCrystal(ItemStack stack) {
        stack.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(xp.getCapacity()));
        return stack;
    }

    public void draw(TokenEnchanterRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        ITextComponent text = TextUtil.translate("misc", "level_cost", recipe.getLevelCost());
        String string = text.getString();
        font.getClass();
        font.func_238405_a_(matrixStack, string, 25.0f, (float)(50 - 9 - 1), -1);
    }
}

