/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;

public class TokenEnchanterRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private int levelCost;
    private ItemStack result;
    private Ingredient token;
    private final Map<Ingredient, Integer> ingredientMap = new LinkedHashMap<Ingredient, Integer>();
    private boolean valid = true;

    public TokenEnchanterRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Ingredient getToken() {
        return this.token;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return Collections.unmodifiableMap(this.ingredientMap);
    }

    public void consumeIngredients(IInventory inv) {
        ItemStack stack = inv.func_70301_a(0);
        stack.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.drainLevels(this.levelCost));
        TokenEnchanterRecipe.consumeItems(inv, 1, 2, (Predicate<ItemStack>)this.token, 1);
        this.ingredientMap.forEach((ingredient, count) -> TokenEnchanterRecipe.consumeItems(inv, 2, inv.func_70302_i_() - 1, (Predicate<ItemStack>)ingredient, count));
    }

    private static void consumeItems(IInventory inventory, int startIndex, int endIndex, Predicate<ItemStack> ingredient, int amount) {
        int amountLeft = amount;
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !ingredient.test(stack)) continue;
            int toRemove = Math.min(amountLeft, stack.func_190916_E());
            stack.func_190918_g(toRemove);
            if (stack.func_190926_b()) {
                inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
            if ((amountLeft -= toRemove) != 0) continue;
            return;
        }
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (!this.valid) {
            return false;
        }
        if (!this.matchesXpCrystal(inv.func_70301_a(0))) {
            return false;
        }
        StackList list = StackList.from((IInventory)inv);
        if (list.firstMatch(s -> this.token.test(s)).func_190926_b()) {
            return false;
        }
        for (Map.Entry<Ingredient, Integer> entry : this.ingredientMap.entrySet()) {
            Ingredient ingredient = entry.getKey();
            int count = entry.getValue();
            int countInInv = 0;
            for (ItemStack stack : list) {
                if (!ingredient.test(stack)) continue;
                countInInv += stack.func_190916_E();
            }
            if (countInInv >= count) continue;
            return false;
        }
        return true;
    }

    private boolean matchesXpCrystal(ItemStack stack) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        return xp.canDrain() && xp.getLevels() >= (float)this.levelCost;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.TOKEN_ENCHANTING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.TOKEN_ENCHANTING_TYPE;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TokenEnchanterRecipe> {
        public TokenEnchanterRecipe read(ResourceLocation recipeId, JsonObject json) {
            int amount;
            JsonElement elem2;
            TokenEnchanterRecipe recipe = new TokenEnchanterRecipe(recipeId);
            recipe.levelCost = JSONUtils.func_151208_a((JsonObject)json, (String)"level_cost", (int)1);
            JsonObject ingredientsJson = json.get("ingredients").getAsJsonObject();
            recipe.token = Ingredient.func_199802_a((JsonElement)ingredientsJson.get("token").getAsJsonObject());
            JsonArray othersArray = ingredientsJson.get("others").getAsJsonArray();
            for (JsonElement elem2 : othersArray) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)elem2);
                int count = JSONUtils.func_151208_a((JsonObject)elem2.getAsJsonObject(), (String)"count", (int)1);
                recipe.ingredientMap.put(ingredient, count);
            }
            JsonObject resultJson = json.get("result").getAsJsonObject();
            recipe.result = Serializer.deserializeItem(resultJson);
            elem2 = resultJson.get("enchantments");
            if (elem2 != null) {
                for (JsonElement elem1 : elem2.getAsJsonArray()) {
                    JsonObject elemObj = elem1.getAsJsonObject();
                    String name = JSONUtils.func_151200_h((JsonObject)elemObj, (String)"name");
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
                    if (enchantment == null) {
                        recipe.valid = false;
                        continue;
                    }
                    int level = JSONUtils.func_151208_a((JsonObject)elemObj, (String)"level", (int)1);
                    Serializer.addEnchantment(recipe.result, enchantment, level);
                }
            }
            if (recipe.result.getCapability(XpStorageCapability.INSTANCE).isPresent() && (amount = JSONUtils.func_151208_a((JsonObject)resultJson, (String)"infuse_levels", (int)0)) > 0) {
                recipe.result.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(amount));
            }
            if (!recipe.valid) {
                Serializer.logInvalidRecipe(recipe);
            }
            return recipe;
        }

        public TokenEnchanterRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            TokenEnchanterRecipe recipe = new TokenEnchanterRecipe(recipeId);
            recipe.levelCost = buffer.func_150792_a();
            recipe.result = buffer.func_150791_c();
            recipe.token = Ingredient.func_199566_b((PacketBuffer)buffer);
            int otherCount = buffer.func_150792_a();
            for (int i = 0; i < otherCount; ++i) {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                int count = buffer.func_150792_a();
                recipe.ingredientMap.put(ingredient, count);
            }
            return recipe;
        }

        public void write(PacketBuffer buffer, TokenEnchanterRecipe recipe) {
            buffer.func_150787_b(recipe.levelCost);
            buffer.func_150788_a(recipe.result);
            recipe.token.func_199564_a(buffer);
            buffer.func_150787_b(recipe.ingredientMap.size());
            recipe.ingredientMap.forEach((ingredient, count) -> {
                ingredient.func_199564_a(buffer);
                buffer.func_150787_b(count.intValue());
            });
        }

        private static ItemStack deserializeItem(JsonObject json) {
            return ShapedRecipe.func_199798_a((JsonObject)json);
        }

        private static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
            stack.func_77966_a(enchantment, level);
        }

        private static void logInvalidRecipe(TokenEnchanterRecipe recipe) {
            String msg = "Token enchanter recipe '{}' is invalid, enchantment does not exist";
            if ("tokenenchanter".equals(recipe.func_199560_c().func_110624_b())) {
                TokenMod.LOGGER.debug(msg, (Object)recipe.func_199560_c());
            } else {
                TokenMod.LOGGER.warn(msg, (Object)recipe.func_199560_c());
            }
        }
    }
}

