/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.silentchaos512.tokenenchanter.loot.function.FillXpItemFunction;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModLoot;
import net.silentchaos512.tokenenchanter.setup.Registration;

public class ModLootTableProvider
extends LootTableProvider {
    public ModLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BlockLootTables(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new ChestLootTables(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }

    private static final class ChestLootTables
    extends net.minecraft.data.loot.ChestLootTables {
        private ChestLootTables() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLoot.Injector.Tables.CHESTS_SIMPLE_DUNGEON, ChestLootTables.addXpItems());
        }

        private static LootTable.Builder addXpItems() {
            LootTable.Builder builder = LootTable.func_216119_b();
            builder.func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ModItems.XP_BREAD).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_(FillXpItemFunction.builder((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ModItems.SMALL_XP_CRYSTAL).func_216086_a(5).func_212841_b_(FillXpItemFunction.builder((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)9.0f)))));
            return builder;
        }
    }

    private static final class BlockLootTables
    extends net.minecraft.data.loot.BlockLootTables {
        private BlockLootTables() {
        }

        protected void addTables() {
            this.func_218492_c((Block)ModBlocks.TOKEN_ENCHANTER.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }
    }
}

