/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.data.client;

import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.tokenenchanter.item.EnchantedTokenItem;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.Registration;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "tokenenchanter", existingFileHelper);
    }

    protected void registerModels() {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(new ResourceLocation("item/generated"));
        Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(this::blockBuilder);
        ModItems.getSimpleModelItems().forEach(arg_0 -> this.lambda$registerModels$0((ModelFile)itemGenerated, arg_0));
        this.registerEnchantedTokens((ModelFile)itemGenerated);
    }

    private void registerEnchantedTokens(ModelFile itemGenerated) {
        for (EnchantedTokenItem.Icon icon : EnchantedTokenItem.Icon.values()) {
            String tokenTexture = icon != EnchantedTokenItem.Icon.CURSE ? "item/gold_token" : "item/cursed_token";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/enchanted_token/" + icon.getName())).parent(itemGenerated)).texture("layer0", this.modLoc(tokenTexture))).texture("layer1", this.modLoc("item/enchanted_token/outline"))).texture("layer2", this.modLoc("item/enchanted_token/" + icon.getName()));
        }
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("enchanted_token")).parent(itemGenerated)).texture("layer0", this.modLoc("item/enchanted_token/any"));
        for (EnchantedTokenItem.Icon icon : EnchantedTokenItem.Icon.values()) {
            builder.override().model((ModelFile)this.getExistingFile(this.modLoc("item/enchanted_token/" + icon.getName()))).predicate(EnchantedTokenItem.MODEL_INDEX, (float)icon.ordinal()).end();
        }
    }

    private void blockBuilder(IBlockProvider block) {
        this.blockBuilder(block.asBlock());
    }

    private void blockBuilder(Block block) {
        String name = NameUtils.from((IForgeRegistryEntry)block).func_110623_a();
        this.withExistingParent(name, this.modLoc("block/" + name));
    }

    private void builder(IItemProvider item, ModelFile parent) {
        String name = NameUtils.fromItem((IItemProvider)item).func_110623_a();
        this.builder(item, parent, "item/" + name);
    }

    private void builder(IItemProvider item, ModelFile parent, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((IItemProvider)item).func_110623_a())).parent(parent)).texture("layer0", this.modLoc(texture));
    }

    private /* synthetic */ void lambda$registerModels$0(ModelFile itemGenerated, ItemRegistryObject iro) {
        this.builder((IItemProvider)iro.get(), itemGenerated);
    }
}

