/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.data.recipe.LibRecipeProvider;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.api.data.TokenEnchantingRecipeBuilder;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;
import net.silentchaos512.tokenenchanter.setup.ModTags;

public class ModRecipeProvider
extends LibRecipeProvider {
    private static final Set<Enchantment> ENCHANTED_TOKEN_RECIPES_CREATED = new HashSet<Enchantment>();

    public ModRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn, "tokenenchanter");
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.registerCustomRecipe(consumer, (SpecialRecipeSerializer)ModRecipes.APPLY_ENCHANTED_TOKEN.get());
        ModRecipeProvider.registerTokenEnchanting(consumer);
        this.shapedBuilder((IItemProvider)ModItems.GOLD_TOKEN, 16).patternLine("///").patternLine("lel").patternLine("///").key(Character.valueOf('/'), (ITag)Tags.Items.INGOTS_GOLD).key(Character.valueOf('l'), (ITag)Tags.Items.GEMS_LAPIS).key(Character.valueOf('e'), (ITag)Tags.Items.GEMS_EMERALD).build(consumer);
        TagEmptyCondition silverTagEmpty = new TagEmptyCondition(ModTags.Items.INGOTS_SILVER.func_230234_a_());
        NotCondition silverTagExists = new NotCondition((ICondition)silverTagEmpty);
        this.shapedBuilder((IItemProvider)ModItems.SILVER_TOKEN, 16).addExtraData(json -> this.writeConditions((JsonObject)json, new ICondition[]{silverTagExists})).patternLine("///").patternLine("lel").patternLine("///").key(Character.valueOf('/'), ModTags.Items.INGOTS_SILVER).key(Character.valueOf('l'), (ITag)Tags.Items.GEMS_LAPIS).key(Character.valueOf('e'), (ITag)Tags.Items.GEMS_EMERALD).build(consumer);
        this.shapedBuilder((IItemProvider)ModItems.SILVER_TOKEN, 8).addExtraData(json -> this.writeConditions((JsonObject)json, new ICondition[]{silverTagEmpty})).patternLine("/n/").patternLine("lel").patternLine("/n/").key(Character.valueOf('/'), (ITag)Tags.Items.INGOTS_IRON).key(Character.valueOf('l'), (ITag)Tags.Items.GEMS_LAPIS).key(Character.valueOf('e'), (ITag)Tags.Items.GEMS_EMERALD).key(Character.valueOf('n'), (ITag)Tags.Items.NUGGETS_GOLD).build(consumer, this.modId("silver_token_no_silver"));
        this.shapedBuilder((IItemProvider)ModBlocks.TOKEN_ENCHANTER).patternLine(" d ").patternLine("/t/").patternLine("o#o").key(Character.valueOf('d'), (ITag)Tags.Items.GEMS_DIAMOND).key(Character.valueOf('/'), (ITag)Tags.Items.INGOTS_GOLD).key(Character.valueOf('t'), ModItems.GOLD_TOKEN).key(Character.valueOf('o'), (ITag)Tags.Items.OBSIDIAN).key(Character.valueOf('#'), (ITag)Tags.Items.STORAGE_BLOCKS_LAPIS).build(consumer);
        this.shapedBuilder((IRecipeSerializer)ModRecipes.SHAPED_XP_CRYSTAL.get(), (IItemProvider)ModItems.SMALL_XP_CRYSTAL).patternLine("e").patternLine("o").patternLine("e").key(Character.valueOf('e'), (ITag)Tags.Items.GEMS_EMERALD).key(Character.valueOf('o'), ModItems.GOLD_TOKEN).build(consumer);
        this.shapedBuilder((IRecipeSerializer)ModRecipes.SHAPED_XP_CRYSTAL.get(), (IItemProvider)ModItems.XP_CRYSTAL).patternLine(" c ").patternLine("bbb").patternLine(" c ").key(Character.valueOf('c'), ModItems.SMALL_XP_CRYSTAL).key(Character.valueOf('b'), (IItemProvider)Items.field_151065_br).build(consumer);
        this.shapedBuilder((IRecipeSerializer)ModRecipes.SHAPED_XP_CRYSTAL.get(), (IItemProvider)ModItems.LARGE_XP_CRYSTAL).patternLine(" c ").patternLine("ene").patternLine(" c ").key(Character.valueOf('c'), ModItems.XP_CRYSTAL).key(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).key(Character.valueOf('n'), (ITag)Tags.Items.NETHER_STARS).build(consumer);
    }

    private static void registerTokenEnchanting(Consumer<IFinishedRecipe> consumer) {
        TokenEnchantingRecipeBuilder.builder((IItemProvider)Items.field_151153_ao, 1, 2).token((IItemProvider)Items.field_151034_e).addIngredient((ITag<Item>)Tags.Items.INGOTS_GOLD, 6).build(consumer, TokenMod.getId("golden_apple"));
        TokenEnchantingRecipeBuilder.builder(ModItems.XP_BREAD, 1, 10).infuseLevels(8).token((IItemProvider)Items.field_151025_P).addIngredient((IItemProvider)Items.field_226638_pX_, 1).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185299_g, 2).addIngredient((ITag<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, 1).addIngredient((IItemProvider)Items.field_196086_aW, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_180312_n, 2).addIngredient((ITag<Item>)Tags.Items.NUGGETS_IRON, 6).addIngredient((IItemProvider)Items.field_151070_bp, 6).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185297_d, 2).addIngredient((ITag<Item>)Tags.Items.INGOTS_BRICK, 8).addIngredient((ITag<Item>)Tags.Items.GUNPOWDER, 6).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_203196_F, 4).addIngredient((IItemProvider)Items.field_205157_eZ, 1).addIngredient((ITag<Item>)Tags.Items.INGOTS_GOLD, 12).addIngredient((IItemProvider)Items.field_151061_bv, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185300_i, 6).addIngredient((IItemProvider)Items.field_234723_bx_, 1).addIngredient((IItemProvider)Items.field_221776_cx, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185305_q, 2).addIngredient((ITag<Item>)Tags.Items.NUGGETS_GOLD, 4).addIngredient((ITag<Item>)Tags.Items.DUSTS_REDSTONE, 9).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_180309_e, 3).addIngredient((ITag<Item>)ItemTags.field_199904_a, 5).addIngredient((ITag<Item>)Tags.Items.FEATHERS, 10).addIngredient((ITag<Item>)Tags.Items.SLIMEBALLS, 2).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_77334_n, 5).addIngredient((IItemProvider)Items.field_151064_bs, 6).addIngredient((ITag<Item>)Tags.Items.NETHERRACK, 30).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_77329_d, 2).addIngredient((IItemProvider)Items.field_221772_cv, 5).addIngredient((ITag<Item>)Tags.Items.INGOTS_NETHER_BRICK, 20).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185311_w, 5).addIngredient((ITag<Item>)Tags.Items.RODS_BLAZE, 3).addIngredient((ITag<Item>)Tags.Items.NETHERRACK, 30).addIngredient((IItemProvider)Items.field_151032_g, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185308_t, 6).addIngredient((ITag<Item>)Tags.Items.GEMS_DIAMOND, 3).addIngredient((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE, 16).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185301_j, 32).addIngredient((IItemProvider)Items.field_222047_ii, 4).addIngredient((ITag<Item>)Tags.Items.GEMS_PRISMARINE, 16).addIngredient((IItemProvider)Items.field_221665_bU, 64).addIngredient((IItemProvider)Items.field_234777_rA_, 32).addIngredient((IItemProvider)Items.field_221958_gk, 32).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_203194_D, 3).addIngredient((IItemProvider)Items.field_205157_eZ, 1).addIngredient((IItemProvider)Items.field_151040_l, 1).addIngredient((ITag<Item>)Tags.Items.DUSTS_PRISMARINE, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185312_x, 16).addIngredient((ITag<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD, 1).addIngredient((IItemProvider)Items.field_151061_bv, 4).addIngredient((IItemProvider)Items.field_151032_g, 64).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_180313_o, 1).addIngredient((IItemProvider)Items.field_221602_aD, 2).addIngredient((ITag<Item>)Tags.Items.FEATHERS, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185304_p, 8).addIngredient((ITag<Item>)Tags.Items.GEMS_EMERALD, 2).addIngredient((ITag<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, 3).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_203193_C, 6).addIngredient((IItemProvider)Items.field_205157_eZ, 1).addIngredient((IItemProvider)Items.field_234729_dO_, 12).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_151370_z, 2).addIngredient((IItemProvider)Items.field_196086_aW, 7).addIngredient((IItemProvider)Items.field_222066_kO, 7).addIngredient((IItemProvider)Items.field_221600_aB, 7).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_151369_A, 2).addIngredient((IItemProvider)Items.field_221737_dE, 4).addIngredient((IItemProvider)Items.field_196087_aX, 6).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185296_A, 32).addIngredient((ITag<Item>)Tags.Items.INGOTS_NETHERITE, 1).addIngredient((IItemProvider)Items.field_151034_e, 64).addIngredient((IItemProvider)Items.field_234719_bC_, 16).addIngredient((IItemProvider)Items.field_234722_bw_, 4).addIngredient((IItemProvider)Items.field_185161_cS, 32).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_222192_G, 16).addIngredient((IItemProvider)Items.field_222114_py, 1).addIngredient((IItemProvider)Items.field_221737_dE, 12).addIngredient((ITag<Item>)Tags.Items.ENDER_PEARLS, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_222194_I, 2).addIngredient((IItemProvider)Items.field_222114_py, 1).addIngredient((IItemProvider)Items.field_221790_de, 12).addIngredient((ITag<Item>)Tags.Items.INGOTS_GOLD, 1).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185309_u, 2).addIngredient((IItemProvider)Items.field_151032_g, 10).addIngredient((ITag<Item>)Tags.Items.STRING, 5).addIngredient((ITag<Item>)Tags.Items.DUSTS_REDSTONE, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_180308_g, 2).addIngredient((ITag<Item>)Tags.Items.INGOTS_IRON, 4).addIngredient((IItemProvider)Items.field_234729_dO_, 2).addIngredient((IItemProvider)Items.field_151032_g, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_180310_c, 2).addIngredient((IItemProvider)Items.field_221790_de, 4).addIngredient((ITag<Item>)Tags.Items.INGOTS_BRICK, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185310_v, 1).addIngredient((IItemProvider)Items.field_221602_aD, 2).addIngredient((IItemProvider)Items.field_151032_g, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_222193_H, 4).addIngredient((IItemProvider)Items.field_222114_py, 1).addIngredient((ITag<Item>)Tags.Items.INGOTS_GOLD, 2).addIngredient((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE, 16).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185298_f, 4).addIngredient((IItemProvider)Items.field_196089_aZ, 2).addIngredient((IItemProvider)Items.field_151069_bo, 9).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_203195_E, 6).addIngredient((IItemProvider)Items.field_205157_eZ, 1).addIngredient((ITag<Item>)Tags.Items.FEATHERS, 20).addIngredient((ITag<Item>)Tags.Items.GEMS_LAPIS, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185302_k, 3).addIngredient((ITag<Item>)Tags.Items.INGOTS_IRON, 1).addIngredient((IItemProvider)Items.field_151145_ak, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185306_r, 12).addIngredient((ITag<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD, 1).addIngredient((ITag<Item>)Tags.Items.RODS_BLAZE, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185303_l, 2).addIngredient((ITag<Item>)Tags.Items.GEMS_LAPIS, 2).addIngredient((IItemProvider)Items.field_151078_bh, 15).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_234847_l_, 4).addIngredient((ITag<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ, 1).addIngredient((IItemProvider)Items.field_234734_dm_, 20).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_191530_r, 1).addIngredient((IItemProvider)Items.field_234729_dO_, 2).addIngredient((IItemProvider)Items.field_222065_kN, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_92091_k, 3).addIngredient((IItemProvider)Items.field_221790_de, 12).addIngredient((IItemProvider)Items.field_221912_fn, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.field_185307_s, 1).addIngredient((ITag<Item>)Tags.Items.INGOTS_IRON, 6).addIngredient((ITag<Item>)Tags.Items.COBBLESTONE, 12).build(consumer);
        ModRecipeProvider.createCursedTokenRecipe(consumer, Enchantments.field_190941_k, (ITag<Item>)Tags.Items.STRING);
        ModRecipeProvider.createCursedTokenRecipe(consumer, Enchantments.field_190940_C, (ITag<Item>)Tags.Items.GUNPOWDER);
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            ResourceLocation id = NameUtils.from((IForgeRegistryEntry)enchantment);
            if (!"minecraft".equals(id.func_110624_b()) || ENCHANTED_TOKEN_RECIPES_CREATED.contains(enchantment)) continue;
            throw new NullPointerException("Missing enchanted token recipe for '" + id + "'");
        }
    }

    private static TokenEnchantingRecipeBuilder enchantedToken(Enchantment enchantment, int levelCost) {
        ENCHANTED_TOKEN_RECIPES_CREATED.add(enchantment);
        return TokenEnchantingRecipeBuilder.enchantedTokenBuilder(enchantment, 1, 1, levelCost).name(ModRecipeProvider.getEnchantedTokenRecipeId(enchantment));
    }

    private static void createCursedTokenRecipe(Consumer<IFinishedRecipe> consumer, Enchantment enchantment, ITag<Item> ingredient) {
        ENCHANTED_TOKEN_RECIPES_CREATED.add(enchantment);
        TokenEnchantingRecipeBuilder.builder(ModItems.ENCHANTED_TOKEN, 1, 1).enchantment(enchantment, 1).token((IItemProvider)ModItems.SILVER_TOKEN).addIngredient(ingredient, 4).build(consumer, ModRecipeProvider.getEnchantedTokenRecipeId(enchantment));
    }

    private static ResourceLocation getEnchantedTokenRecipeId(Enchantment enchantment) {
        ResourceLocation enchantmentId = NameUtils.from((IForgeRegistryEntry)enchantment);
        return TokenMod.getId(String.format("enchanted_token/%s.%s", enchantmentId.func_110624_b(), enchantmentId.func_110623_a()));
    }

    protected void writeConditions(JsonObject json, ICondition ... conditions) {
        if (conditions.length > 0) {
            JsonArray array = new JsonArray();
            for (ICondition condition : conditions) {
                array.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)array);
        }
    }
}

