/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.item;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.tokenenchanter.TokenMod;

public class EnchantedTokenItem
extends Item {
    public static final ResourceLocation MODEL_INDEX = TokenMod.getId("model_index");
    private static final Map<Enchantment, Integer> OUTLINE_COLOR_MAP = new HashMap<Enchantment, Integer>();
    private static final Map<String, Icon> MODELS_BY_TYPE = new HashMap<String, Icon>();
    private static final float OUTLINE_PULSATE_SPEED = 0.10610329f;

    public EnchantedTokenItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack construct(Enchantment enchantment, int level) {
        return this.construct(new EnchantmentData(enchantment, level));
    }

    public ItemStack construct(EnchantmentData ... enchantments) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        for (EnchantmentData data : enchantments) {
            EnchantedTokenItem.addEnchantment(stack, data);
        }
        return stack;
    }

    public static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
        EnchantedTokenItem.addEnchantment(stack, new EnchantmentData(enchantment, level));
    }

    private static void addEnchantment(ItemStack stack, EnchantmentData data) {
        stack.func_77966_a(data.field_76302_b, data.field_76303_c);
    }

    public static ItemStack applyTokenToItem(ItemStack token, ItemStack stack) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() == Items.field_151134_bR) {
            return EnchantedTokenItem.applyTokenToBook(token, stack);
        }
        return EnchantedTokenItem.applyTokenToTool(token, stack);
    }

    public static ItemStack applyTokenToBook(ItemStack token, ItemStack book) {
        ItemStack ret = book.func_77973_b() == Items.field_151122_aG ? new ItemStack((IItemProvider)Items.field_151134_bR) : book.func_77946_l();
        Map enchantmentsOnToken = EnchantmentHelper.func_82781_a((ItemStack)token);
        if (enchantmentsOnToken.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Map enchantmentsOnBook = EnchantmentHelper.func_82781_a((ItemStack)ret);
        if (!EnchantedTokenItem.mergeEnchantmentLists(enchantmentsOnToken, enchantmentsOnBook)) {
            return ItemStack.field_190927_a;
        }
        EnchantmentHelper.func_82782_a((Map)enchantmentsOnToken, (ItemStack)ret);
        return ret;
    }

    public static ItemStack applyTokenToTool(ItemStack token, ItemStack tool) {
        if (token.func_190926_b() || tool.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Map enchantmentsOnToken = EnchantmentHelper.func_82781_a((ItemStack)token);
        if (enchantmentsOnToken.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Map enchantmentsOnTool = EnchantmentHelper.func_82781_a((ItemStack)tool);
        for (Map.Entry entry : enchantmentsOnToken.entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            if (!ench.func_92089_a(tool)) {
                return ItemStack.field_190927_a;
            }
            for (Enchantment enchTool : enchantmentsOnTool.keySet()) {
                if (ench.equals(enchTool) || ench.func_191560_c(enchTool)) continue;
                return ItemStack.field_190927_a;
            }
        }
        if (!EnchantedTokenItem.mergeEnchantmentLists(enchantmentsOnToken, enchantmentsOnTool)) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = tool.func_77946_l();
        EnchantmentHelper.func_82782_a((Map)enchantmentsOnToken, (ItemStack)ret);
        return ret;
    }

    private static boolean mergeEnchantmentLists(Map<Enchantment, Integer> first, Map<Enchantment, Integer> second) {
        for (Enchantment enchantment : second.keySet()) {
            int newLevel;
            int level = newLevel = second.get(enchantment).intValue();
            if (first.containsKey(enchantment) && (newLevel = first.get(enchantment) + level) > enchantment.func_77325_b()) {
                return false;
            }
            first.put(enchantment, newLevel);
        }
        return true;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Enchantment enchantment = EnchantedTokenItem.getSingleEnchantment(stack);
        if (enchantment != null) {
            IFormattableTextComponent enchantmentName = enchantment.func_200305_d(1).func_230531_f_().func_240699_a_(this.func_77613_e((ItemStack)stack).field_77937_e);
            return new TranslationTextComponent(this.func_77667_c(stack) + ".single", new Object[]{enchantmentName});
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (enchantments.size() == 1) {
            Enchantment enchantment = (Enchantment)enchantments.keySet().iterator().next();
            list.add(this.subText("maxLevel", enchantment.func_77325_b()));
            list.add(this.subText("mod", EnchantedTokenItem.getModName(enchantment)));
            if (flag.func_194127_a()) {
                ResourceLocation registryName = Objects.requireNonNull(enchantment.getRegistryName());
                list.add((ITextComponent)new StringTextComponent(registryName.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    private static String getModName(Enchantment enchantment) {
        return ModList.get().getModContainerById(NameUtils.from((IForgeRegistryEntry)enchantment).func_110624_b()).map(c -> c.getModInfo().getDisplayName()).orElse("Unknown Mod");
    }

    private ITextComponent subText(String key, Object ... formatArgs) {
        ResourceLocation id = NameUtils.from((IForgeRegistryEntry)this);
        String fullKey = String.format("item.%s.%s.%s", id.func_110624_b(), id.func_110623_a(), key);
        return new TranslationTextComponent(fullKey, formatArgs);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        NonNullList tokens = NonNullList.func_191196_a();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            tokens.add(this.construct(enchantment, 1));
        }
        tokens.sort(EnchantedTokenItem::compareEnchantmentNames);
        items.addAll((Collection)tokens);
    }

    private static int compareEnchantmentNames(ItemStack o1, ItemStack o2) {
        int k = Integer.compare(EnchantedTokenItem.getModelIcon(o1).ordinal(), EnchantedTokenItem.getModelIcon(o2).ordinal());
        if (k == 0) {
            Enchantment e1 = EnchantedTokenItem.getSingleEnchantment(o1);
            Enchantment e2 = EnchantedTokenItem.getSingleEnchantment(o2);
            if (e1 != null && e2 != null) {
                ITextComponent name1 = EnchantedTokenItem.getEnchantmentDisplayName(e1);
                ITextComponent name2 = EnchantedTokenItem.getEnchantmentDisplayName(e2);
                return name1.getString().compareTo(name2.getString());
            }
        }
        return k;
    }

    private static ITextComponent getEnchantmentDisplayName(Enchantment enchantment) {
        try {
            return enchantment.func_200305_d(1);
        }
        catch (Throwable ex) {
            CrashReport report = CrashReport.func_85055_a((Throwable)ex, (String)"Enchantment threw an exception when getting display name. This is not Token Enchanter's fault!");
            CrashReportCategory cat = report.func_85058_a("Enchantment");
            cat.func_71507_a("ID", (Object)NameUtils.from((IForgeRegistryEntry)enchantment));
            cat.func_71507_a("Mod Name", (Object)EnchantedTokenItem.getModName(enchantment));
            throw new ReportedException(report);
        }
    }

    @Nullable
    public static Enchantment getSingleEnchantment(ItemStack token) {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)token);
        if (map.size() != 1) {
            return null;
        }
        return (Enchantment)map.keySet().iterator().next();
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        int baseColor = EnchantedTokenItem.getOutlineColor(stack);
        int j = (int)(160.0f * MathHelper.func_76126_a((float)((float)ClientTicks.ticksInGame() * 0.10610329f)));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)255);
        int r = baseColor >> 16 & 0xFF;
        r = MathHelper.func_76125_a((int)(r + j), (int)0, (int)255);
        int g = baseColor >> 8 & 0xFF;
        g = MathHelper.func_76125_a((int)(g + j), (int)0, (int)255);
        int b = baseColor & 0xFF;
        b = MathHelper.func_76125_a((int)(b + j), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    private static int getOutlineColor(ItemStack stack) {
        Enchantment enchantment = EnchantedTokenItem.getSingleEnchantment(stack);
        if (enchantment != null) {
            return OUTLINE_COLOR_MAP.computeIfAbsent(enchantment, e -> {
                int hash = NameUtils.from((IForgeRegistryEntry)e).hashCode();
                float hue = (float)((hash + 32 * OUTLINE_COLOR_MAP.size()) % 1024) / 1024.0f;
                return Color.getHSBColor(hue, 1.0f, 1.0f).getRGB();
            });
        }
        return 8405196;
    }

    public static float getModel(ItemStack stack, World world, LivingEntity entity) {
        return EnchantedTokenItem.getModelIcon(stack).ordinal();
    }

    private static Icon getModelIcon(ItemStack stack) {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (map.isEmpty()) {
            return Icon.UNKNOWN;
        }
        Enchantment enchantment = (Enchantment)map.keySet().iterator().next();
        if (enchantment.func_190936_d()) {
            return Icon.CURSE;
        }
        EnchantmentType type = enchantment.field_77351_y;
        if (type == null) {
            return Icon.UNKNOWN;
        }
        return MODELS_BY_TYPE.getOrDefault(type.toString(), Icon.UNKNOWN);
    }

    static {
        MODELS_BY_TYPE.put(EnchantmentType.VANISHABLE.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnchantmentType.BREAKABLE.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_CHEST.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_FEET.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_HEAD.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_LEGS.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.WEARABLE.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.BOW.toString(), Icon.BOW);
        MODELS_BY_TYPE.put(EnchantmentType.CROSSBOW.toString(), Icon.CROSSBOW);
        MODELS_BY_TYPE.put(EnchantmentType.DIGGER.toString(), Icon.TOOL);
        MODELS_BY_TYPE.put(EnchantmentType.FISHING_ROD.toString(), Icon.FISHING_ROD);
        MODELS_BY_TYPE.put(EnchantmentType.TRIDENT.toString(), Icon.TRIDENT);
        MODELS_BY_TYPE.put(EnchantmentType.WEAPON.toString(), Icon.SWORD);
        if (TokenMod.isDevBuild()) {
            TokenMod.LOGGER.info("Checking enchantment type icons...");
            boolean allGood = true;
            for (EnchantmentType type : EnchantmentType.values()) {
                if (MODELS_BY_TYPE.containsKey(type.toString())) continue;
                TokenMod.LOGGER.fatal("Missing icon for type: {}", (Object)type);
                allGood = false;
            }
            if (allGood) {
                TokenMod.LOGGER.info("All good!");
            }
        }
    }

    public static enum Icon {
        ANY,
        TOOL,
        SWORD,
        FISHING_ROD,
        TRIDENT,
        BOW,
        CROSSBOW,
        ARMOR,
        CURSE,
        UNKNOWN;


        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

