/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageItemImpl;
import net.silentchaos512.tokenenchanter.util.TextUtil;

public class XpCrystalItem
extends Item {
    private final int maxLevels;

    public XpCrystalItem(int maxLevels, Item.Properties properties) {
        super(properties);
        this.maxLevels = maxLevels;
    }

    private static int getFillAmount(ItemStack stack) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        int normalAmount = xp.getCapacity() / 5;
        int freeSpace = (int)((float)xp.getCapacity() - xp.getLevels());
        return Math.min(freeSpace, normalAmount);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        float levels = xp.getLevels();
        float max = xp.getCapacity();
        if (max == 0.0f) {
            return 1.0;
        }
        return (max - levels) / max;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == XpStorageCapability.INSTANCE) {
                    return LazyOptional.of(() -> new XpStorageItemImpl(stack, XpCrystalItem.this.maxLevels, true)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    private static int getPlayerLevel(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            return player.field_71075_bZ.field_75098_d ? Integer.MAX_VALUE : player.field_71068_ca;
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        int fillAmount = XpCrystalItem.getFillAmount(stack);
        if (xp.getLevels() < (float)xp.getCapacity()) {
            if (XpCrystalItem.getPlayerLevel((LivingEntity)playerIn) >= fillAmount) {
                playerIn.func_184598_c(handIn);
                return ActionResult.func_226249_b_((Object)stack);
            }
            ITextComponent msg = TextUtil.translate("item", "xp_crystal.not_enough_levels", fillAmount);
            playerIn.func_146105_b(msg, true);
            playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
            return ActionResult.func_226251_d_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        int fillAmount;
        int playerLevels = XpCrystalItem.getPlayerLevel(entityLiving);
        if (playerLevels >= (fillAmount = XpCrystalItem.getFillAmount(stack)) && entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            player.func_82242_a(-fillAmount);
            ItemStack ret = stack.func_77946_l();
            ret.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(fillAmount));
            return ret;
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        float levels = xp.getLevels();
        if (levels <= 0.1f) {
            tooltip.add((ITextComponent)TextUtil.translate("item", "xp_crystal.hint", new Object[0]).func_230531_f_().func_240699_a_(TextFormatting.ITALIC));
        }
        String levelsFormatted = String.format("%.1f", Float.valueOf(levels));
        String max = String.valueOf(xp.getCapacity());
        tooltip.add(TextUtil.translate("item", "xp_crystal.levels", levelsFormatted, max));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack empty = new ItemStack((IItemProvider)this);
            items.add((Object)empty);
            ItemStack full = empty.func_77946_l();
            full.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(xp.getCapacity()));
            items.add((Object)full);
        }
    }
}

