/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageItemImpl;
import net.silentchaos512.tokenenchanter.util.TextUtil;

public class XpFoodItem
extends Item {
    public XpFoodItem(Item.Properties properties) {
        super(properties);
        if (!this.func_219971_r()) {
            throw new IllegalArgumentException("XpFoodItem must be a food");
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == XpStorageCapability.INSTANCE) {
                    return LazyOptional.of(() -> new XpStorageItemImpl(stack, Integer.MAX_VALUE, false)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            float levels = stack.getCapability(XpStorageCapability.INSTANCE).map(IXpStorage::getLevels).orElse(Float.valueOf(0.0f)).floatValue();
            ((PlayerEntity)entityLiving).func_82242_a(Math.round(levels));
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        float levels = stack.getCapability(XpStorageCapability.INSTANCE).map(IXpStorage::getLevels).orElse(Float.valueOf(0.0f)).floatValue();
        tooltip.add(TextUtil.translate("item", "xp_food.levels", Float.valueOf(levels)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.createWithLevels(5));
            items.add((Object)this.createWithLevels(10));
            items.add((Object)this.createWithLevels(20));
            items.add((Object)this.createWithLevels(30));
        }
    }

    public ItemStack createWithLevels(int levels) {
        ItemStack ret = new ItemStack((IItemProvider)this);
        ret.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.setLevels(levels));
        return ret;
    }
}

