/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.setup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.item.EnchantedTokenItem;
import net.silentchaos512.tokenenchanter.item.XpCrystalItem;
import net.silentchaos512.tokenenchanter.item.XpFoodItem;
import net.silentchaos512.tokenenchanter.setup.Registration;

public final class ModItems {
    private static final Collection<ItemRegistryObject<? extends Item>> SIMPLE_MODEL_ITEMS = new ArrayList<ItemRegistryObject<? extends Item>>();
    public static final ItemRegistryObject<Item> GOLD_TOKEN = ModItems.registerCraftingItem("gold_token");
    public static final ItemRegistryObject<Item> SILVER_TOKEN = ModItems.registerCraftingItem("silver_token");
    public static final ItemRegistryObject<XpCrystalItem> SMALL_XP_CRYSTAL = ModItems.registerSimpleModel("small_xp_crystal", () -> new XpCrystalItem(10, ModItems.unstackableProps()));
    public static final ItemRegistryObject<XpCrystalItem> XP_CRYSTAL = ModItems.registerSimpleModel("xp_crystal", () -> new XpCrystalItem(30, ModItems.unstackableProps()));
    public static final ItemRegistryObject<XpCrystalItem> LARGE_XP_CRYSTAL = ModItems.registerSimpleModel("large_xp_crystal", () -> new XpCrystalItem(100, ModItems.unstackableProps()));
    public static final ItemRegistryObject<XpFoodItem> XP_BREAD = ModItems.registerSimpleModel("xp_bread", () -> new XpFoodItem(ModItems.baseProps().func_221540_a(new Food.Builder().func_221456_a(6).func_221454_a(1.2f).func_221455_b().func_221453_d())));
    public static final ItemRegistryObject<EnchantedTokenItem> ENCHANTED_TOKEN = ModItems.register("enchanted_token", () -> new EnchantedTokenItem(ModItems.baseProps()));

    private ModItems() {
    }

    static void register() {
    }

    public static Collection<ItemRegistryObject<? extends Item>> getSimpleModelItems() {
        return Collections.unmodifiableCollection(SIMPLE_MODEL_ITEMS);
    }

    private static <T extends Item> ItemRegistryObject<T> register(String name, Supplier<T> item) {
        return new ItemRegistryObject(Registration.ITEMS.register(name, item));
    }

    private static <T extends Item> ItemRegistryObject<T> registerSimpleModel(String name, Supplier<T> item) {
        ItemRegistryObject<T> ret = ModItems.register(name, item);
        SIMPLE_MODEL_ITEMS.add(ret);
        return ret;
    }

    private static ItemRegistryObject<Item> registerCraftingItem(String name) {
        return ModItems.registerSimpleModel(name, () -> new Item(ModItems.baseProps()));
    }

    private static Item.Properties baseProps() {
        return new Item.Properties().func_200916_a(TokenMod.ITEM_GROUP);
    }

    private static Item.Properties unstackableProps() {
        return ModItems.baseProps().func_200917_a(1);
    }
}

