/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.setup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.loot.function.FillXpItemFunction;

public class ModLoot {
    public static final LootFunctionType FILL_XP_ITEM = new LootFunctionType((ILootSerializer)FillXpItemFunction.SERIALIZER);

    static void register() {
        Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)TokenMod.getId("fill_xp_item"), (Object)FILL_XP_ITEM);
    }

    @Mod.EventBusSubscriber
    public static final class Injector {
        private Injector() {
        }

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            Tables.get(event.getName()).ifPresent(injectorName -> {
                TokenMod.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
                event.getTable().addPool(LootPool.func_216096_a().name("tokenenchanter_injected").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)injectorName)).func_216044_b());
            });
        }

        public static final class Tables {
            private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
            public static final ResourceLocation CHESTS_SIMPLE_DUNGEON = Tables.inject(LootTables.field_186422_d);

            private Tables() {
            }

            public static Collection<ResourceLocation> getValues() {
                return MAP.values();
            }

            public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
                return Optional.ofNullable(MAP.get(lootTable));
            }

            private static ResourceLocation inject(ResourceLocation lootTable) {
                ResourceLocation ret = TokenMod.getId("inject/" + lootTable.func_110623_a());
                MAP.put(lootTable, ret);
                return ret;
            }
        }
    }
}

