/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.setup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.loot.function.FillXpItemFunction;

public class ModLoot {
    public static final LootItemFunctionType FILL_XP_ITEM = new LootItemFunctionType((Serializer)FillXpItemFunction.SERIALIZER);

    static void register() {
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)TokenMod.getId("fill_xp_item"), (Object)FILL_XP_ITEM);
    }

    @Mod.EventBusSubscriber
    public static final class Injector {
        private Injector() {
        }

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            Tables.get(event.getName()).ifPresent(injectorName -> {
                TokenMod.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
                event.getTable().addPool(LootPool.m_79043_().name("tokenenchanter_injected").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)injectorName)).m_79082_());
            });
        }

        public static final class Tables {
            private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
            public static final ResourceLocation CHESTS_SIMPLE_DUNGEON = Tables.inject(BuiltInLootTables.f_78742_);

            private Tables() {
            }

            public static Collection<ResourceLocation> getValues() {
                return MAP.values();
            }

            public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
                return Optional.ofNullable(MAP.get(lootTable));
            }

            private static ResourceLocation inject(ResourceLocation lootTable) {
                ResourceLocation ret = TokenMod.getId("inject/" + lootTable.m_135815_());
                MAP.put(lootTable, ret);
                return ret;
            }
        }
    }
}

