/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.command.internal;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.silentchaos512.lib.network.internal.DisplayNBTPacket;
import net.silentchaos512.lib.network.internal.SilentLibNetwork;

public class DisplayNBTCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sl_nbt").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"block").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(DisplayNBTCommand::runForBlock)))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(DisplayNBTCommand::runForEntity)))).then(Commands.m_82127_((String)"item").executes(DisplayNBTCommand::runForItem)));
    }

    private static int runForBlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockEntity tileEntity = world.m_7702_(pos);
        TranslatableComponent title = new TranslatableComponent(world.m_8055_(pos).m_60734_().m_7705_());
        if (tileEntity != null) {
            DisplayNBTCommand.sendPacket(context, tileEntity.m_6945_(new CompoundTag()), (Component)title);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)new TranslatableComponent("command.silentlib.nbt.notBlockEntity", new Object[]{title}));
        return 0;
    }

    private static int runForEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        CompoundTag nbt = entity.m_20240_(new CompoundTag());
        Component title = entity.m_5446_();
        DisplayNBTCommand.sendPacket(context, nbt, title);
        return 1;
    }

    private static int runForItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack stack = ((CommandSourceStack)context.getSource()).m_81375_().m_21205_();
        if (stack.m_41619_()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TranslatableComponent("command.silentlib.nbt.noItemInHand"));
            return 0;
        }
        if (!stack.m_41782_()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TranslatableComponent("command.silentlib.nbt.noItemTag", new Object[]{stack.m_41786_()}));
            return 0;
        }
        DisplayNBTCommand.sendPacket(context, stack.m_41784_(), stack.m_41786_());
        return 1;
    }

    private static void sendPacket(CommandContext<CommandSourceStack> context, CompoundTag nbt, Component title) throws CommandSyntaxException {
        DisplayNBTPacket msg = new DisplayNBTPacket(nbt, DisplayNBTCommand.textOfNullable(title));
        Connection netManager = ((CommandSourceStack)context.getSource()).m_81375_().f_8906_.f_9742_;
        SilentLibNetwork.channel.sendTo((Object)msg, netManager, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static Component textOfNullable(@Nullable Component text) {
        return text == null ? new TextComponent("null") : text;
    }
}

