/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class DimensionId {
    private final ResourceKey<Level> id;
    private static final Lazy<DimensionId> OVERWORLD = Lazy.of(() -> new DimensionId((ResourceKey<Level>)Level.f_46428_));

    private DimensionId(ResourceKey<Level> id) {
        this.id = id;
    }

    public static DimensionId overworld() {
        return (DimensionId)OVERWORLD.get();
    }

    public static DimensionId fromId(ResourceKey<Level> id) {
        return new DimensionId(id);
    }

    public static DimensionId fromPacket(FriendlyByteBuf buf) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        return new DimensionId((ResourceKey<Level>)key);
    }

    public static DimensionId fromWorld(Level world) {
        return new DimensionId((ResourceKey<Level>)world.m_46472_());
    }

    public static DimensionId fromResourceLocation(ResourceLocation location) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)location);
        return new DimensionId((ResourceKey<Level>)key);
    }

    public ResourceKey<Level> getId() {
        return this.id;
    }

    public ResourceLocation getRegistryName() {
        return this.id.m_135782_();
    }

    public String getName() {
        return this.id.m_135782_().m_135815_();
    }

    public boolean isOverworld() {
        return this.id.equals((Object)Level.f_46428_);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.id.m_135782_());
    }

    public ServerLevel loadWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.m_129880_(this.id);
    }

    public ServerLevel getWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.m_129880_(this.id);
    }

    public ServerLevel loadWorld(Level otherWorld) {
        return otherWorld.m_142572_().m_129880_(this.id);
    }

    public static boolean sameDimension(Level world1, Level world2) {
        return world1.m_46472_().equals((Object)world2.m_46472_());
    }

    public boolean sameDimension(Level world) {
        return this.id.equals((Object)world.m_46472_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionId that = (DimensionId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

