/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.compat.jei;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterContainerMenu;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterContainerScreen;
import net.silentchaos512.tokenenchanter.compat.jei.TokenEnchantingRecipeCategoryJei;
import net.silentchaos512.tokenenchanter.item.EnchantedTokenItem;
import net.silentchaos512.tokenenchanter.item.XpCrystalItem;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;

@JeiPlugin
public class TokenEnchanterJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = TokenMod.getId("plugin");
    static final ResourceLocation TOKEN_ENCHANTING = TokenMod.getId("category/token_enchanting");

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new TokenEnchantingRecipeCategoryJei(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        reg.addRecipes(TokenEnchanterJeiPlugin.getRecipesOfType(ModRecipes.TOKEN_ENCHANTING_TYPE), TOKEN_ENCHANTING);
    }

    private static List<Recipe<?>> getRecipesOfType(RecipeType<?> recipeType) {
        Level world = (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        return world.m_7465_().m_44051_().stream().filter(r -> r.m_6671_() == recipeType).collect(Collectors.toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack(ModBlocks.TOKEN_ENCHANTER), new ResourceLocation[]{TOKEN_ENCHANTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(TokenEnchanterContainerScreen.class, 102, 32, 24, 23, new ResourceLocation[]{TOKEN_ENCHANTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(TokenEnchanterContainerMenu.class, TOKEN_ENCHANTING, 0, 8, 9, 36);
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)ModItems.ENCHANTED_TOKEN.get(), (stack, context) -> {
            Enchantment enchantment = EnchantedTokenItem.getSingleEnchantment(stack);
            return enchantment != null ? enchantment.m_44704_() : "none";
        });
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof XpCrystalItem).forEach(item -> reg.registerSubtypeInterpreter(item, (stack, context) -> String.valueOf(XpCrystalItem.getLevels(stack))));
    }
}

