/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.tags.ITagManager;

public final class TagUtils {
    private TagUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean contains(TagKey<Item> tag, ItemStack stack) {
        return TagUtils.contains(ForgeRegistries.ITEMS, tag, stack.m_41720_());
    }

    public static boolean contains(TagKey<Block> tag, BlockState state) {
        return TagUtils.contains(ForgeRegistries.BLOCKS, tag, state.m_60734_());
    }

    public static boolean contains(TagKey<EntityType<?>> tag, Entity entity) {
        return TagUtils.contains(ForgeRegistries.ENTITIES, tag, entity.m_6095_());
    }

    public static <T extends IForgeRegistryEntry<T>> boolean contains(TagKey<T> tag, T obj) {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(obj.getRegistryName());
        return TagUtils.contains(registry, tag, obj);
    }

    public static <T extends IForgeRegistryEntry<T>> boolean contains(IForgeRegistry<T> registry, TagKey<T> tag, T obj) {
        ITagManager tagManager = registry.tags();
        return tagManager != null && tagManager.getTag(tag).contains(obj);
    }

    public static Stream<Item> getItemsInTag(TagKey<Item> tag) {
        return TagUtils.getObjectsInTag(ForgeRegistries.ITEMS, tag);
    }

    public static Stream<Block> getBlocksInTag(TagKey<Block> tag) {
        return TagUtils.getObjectsInTag(ForgeRegistries.BLOCKS, tag);
    }

    public static <T extends IForgeRegistryEntry<T>> Stream<T> getObjectsInTag(IForgeRegistry<T> registry, TagKey<T> tag) {
        ITagManager tagManager = registry.tags();
        if (tagManager != null) {
            return tagManager.getTag(tag).stream();
        }
        return Stream.of(new IForgeRegistryEntry[0]);
    }
}

