/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.api.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;
import net.silentchaos512.tokenenchanter.setup.ModTags;

public class TokenEnchantingRecipeBuilder {
    private ResourceLocation name;
    private final Item result;
    private final int count;
    private final int levelCost;
    private Ingredient token;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();
    private final Map<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>();
    private int infuseLevels = 0;

    protected TokenEnchantingRecipeBuilder(ItemLike result, int count, int levelCost) {
        this.result = result.m_5456_();
        this.count = count;
        this.levelCost = levelCost;
    }

    public static TokenEnchantingRecipeBuilder builder(ItemLike result, int count, int levelCost) {
        return new TokenEnchantingRecipeBuilder(result, count, levelCost);
    }

    public static TokenEnchantingRecipeBuilder enchantedTokenBuilder(Enchantment enchantment, int enchantmentLevel, int count, int levelCost) {
        return TokenEnchantingRecipeBuilder.builder(ModItems.ENCHANTED_TOKEN, count, levelCost).enchantment(enchantment, enchantmentLevel).token(ModTags.Items.TOKENS_GOLD);
    }

    public TokenEnchantingRecipeBuilder name(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public TokenEnchantingRecipeBuilder enchantment(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public TokenEnchantingRecipeBuilder infuseLevels(int levels) {
        if (!new ItemStack((ItemLike)this.result).getCapability(XpStorageCapability.INSTANCE).isPresent()) {
            throw new IllegalStateException("Item '" + NameUtils.from((IForgeRegistryEntry)this.result) + "' has no XP storage capability");
        }
        this.infuseLevels = levels;
        return this;
    }

    public TokenEnchantingRecipeBuilder token(ItemLike item) {
        return this.token(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public TokenEnchantingRecipeBuilder token(TagKey<Item> tag) {
        return this.token(Ingredient.m_204132_(tag));
    }

    public TokenEnchantingRecipeBuilder token(Ingredient ingredient) {
        this.token = ingredient;
        return this;
    }

    public TokenEnchantingRecipeBuilder addIngredient(ItemLike item, int count) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), count);
    }

    public TokenEnchantingRecipeBuilder addIngredient(TagKey<Item> tag, int count) {
        return this.addIngredient(Ingredient.m_204132_(tag), count);
    }

    public TokenEnchantingRecipeBuilder addIngredient(Ingredient ingredient, int count) {
        this.ingredients.put(ingredient, count);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        ResourceLocation itemId = NameUtils.from((IForgeRegistryEntry)this.result);
        ResourceLocation id = this.name == null ? itemId : this.name;
        this.build(consumer, id);
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final TokenEnchantingRecipeBuilder builder;

        public Result(ResourceLocation id, TokenEnchantingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("level_cost", (Number)this.builder.levelCost);
            JsonObject ingredients = new JsonObject();
            ingredients.add("token", this.builder.token.m_43942_());
            JsonArray others = new JsonArray();
            this.builder.ingredients.forEach((ing, count) -> {
                JsonObject j = ing.m_43942_().getAsJsonObject();
                j.addProperty("count", (Number)count);
                others.add((JsonElement)j);
            });
            ingredients.add("others", (JsonElement)others);
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.from((IForgeRegistryEntry)this.builder.result).toString());
            if (this.builder.count > 1) {
                result.addProperty("count", (Number)this.builder.count);
            }
            if (!this.builder.enchantments.isEmpty()) {
                JsonArray array = new JsonArray();
                this.builder.enchantments.forEach((enchantment, level) -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("name", NameUtils.from((IForgeRegistryEntry)enchantment).toString());
                    obj.addProperty("level", (Number)level);
                    array.add((JsonElement)obj);
                });
                result.add("enchantments", (JsonElement)array);
            }
            if (this.builder.infuseLevels > 0) {
                result.addProperty("infuse_levels", (Number)this.builder.infuseLevels);
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.TOKEN_ENCHANTING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

