/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;

public class TokenEnchanterRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private int levelCost;
    private ItemStack result;
    private Ingredient token;
    private final Map<Ingredient, Integer> ingredientMap = new LinkedHashMap<Ingredient, Integer>();
    private boolean valid = true;

    public TokenEnchanterRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Ingredient getToken() {
        return this.token;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return Collections.unmodifiableMap(this.ingredientMap);
    }

    public void consumeIngredients(Container inv) {
        ItemStack stack = inv.m_8020_(0);
        stack.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.drainLevels(this.levelCost));
        TokenEnchanterRecipe.consumeItems(inv, 1, 2, (Predicate<ItemStack>)this.token, 1);
        this.ingredientMap.forEach((ingredient, count) -> TokenEnchanterRecipe.consumeItems(inv, 2, inv.m_6643_() - 1, (Predicate<ItemStack>)ingredient, count));
    }

    private static void consumeItems(Container inventory, int startIndex, int endIndex, Predicate<ItemStack> ingredient, int amount) {
        int amountLeft = amount;
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !ingredient.test(stack)) continue;
            int toRemove = Math.min(amountLeft, stack.m_41613_());
            stack.m_41774_(toRemove);
            if (stack.m_41619_()) {
                inventory.m_6836_(i, ItemStack.f_41583_);
            }
            if ((amountLeft -= toRemove) != 0) continue;
            return;
        }
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (!this.valid) {
            return false;
        }
        if (!this.matchesXpCrystal(inv.m_8020_(0))) {
            return false;
        }
        StackList list = StackList.from((Container)inv);
        if (list.firstMatch(s -> this.token.test(s)).m_41619_()) {
            return false;
        }
        for (Map.Entry<Ingredient, Integer> entry : this.ingredientMap.entrySet()) {
            Ingredient ingredient = entry.getKey();
            int count = entry.getValue();
            int countInInv = 0;
            for (ItemStack stack : list) {
                if (!ingredient.test(stack)) continue;
                countInInv += stack.m_41613_();
            }
            if (countInInv >= count) continue;
            return false;
        }
        return true;
    }

    private boolean matchesXpCrystal(ItemStack stack) {
        IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
        return xp.canDrain() && xp.getLevels() >= (float)this.levelCost;
    }

    public ItemStack m_5874_(Container inv) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.TOKEN_ENCHANTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.TOKEN_ENCHANTING_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<TokenEnchanterRecipe> {
        public TokenEnchanterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int amount;
            JsonElement elem2;
            TokenEnchanterRecipe recipe = new TokenEnchanterRecipe(recipeId);
            recipe.levelCost = GsonHelper.m_13824_((JsonObject)json, (String)"level_cost", (int)1);
            JsonObject ingredientsJson = json.get("ingredients").getAsJsonObject();
            recipe.token = Ingredient.m_43917_((JsonElement)ingredientsJson.get("token").getAsJsonObject());
            JsonArray othersArray = ingredientsJson.get("others").getAsJsonArray();
            for (JsonElement elem2 : othersArray) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)elem2);
                int count = GsonHelper.m_13824_((JsonObject)elem2.getAsJsonObject(), (String)"count", (int)1);
                recipe.ingredientMap.put(ingredient, count);
            }
            JsonObject resultJson = json.get("result").getAsJsonObject();
            recipe.result = Serializer.deserializeItem(resultJson);
            elem2 = resultJson.get("enchantments");
            if (elem2 != null) {
                for (JsonElement elem1 : elem2.getAsJsonArray()) {
                    JsonObject elemObj = elem1.getAsJsonObject();
                    String name = GsonHelper.m_13906_((JsonObject)elemObj, (String)"name");
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
                    if (enchantment == null) {
                        recipe.valid = false;
                        continue;
                    }
                    int level = GsonHelper.m_13824_((JsonObject)elemObj, (String)"level", (int)1);
                    Serializer.addEnchantment(recipe.result, enchantment, level);
                }
            }
            if (recipe.result.getCapability(XpStorageCapability.INSTANCE).isPresent() && (amount = GsonHelper.m_13824_((JsonObject)resultJson, (String)"infuse_levels", (int)0)) > 0) {
                recipe.result.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(amount));
            }
            if (!recipe.valid) {
                Serializer.logInvalidRecipe(recipe);
            }
            return recipe;
        }

        public TokenEnchanterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            TokenEnchanterRecipe recipe = new TokenEnchanterRecipe(recipeId);
            recipe.levelCost = buffer.m_130242_();
            recipe.result = buffer.m_130267_();
            recipe.token = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int otherCount = buffer.m_130242_();
            for (int i = 0; i < otherCount; ++i) {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int count = buffer.m_130242_();
                recipe.ingredientMap.put(ingredient, count);
            }
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, TokenEnchanterRecipe recipe) {
            buffer.m_130130_(recipe.levelCost);
            buffer.m_130055_(recipe.result);
            recipe.token.m_43923_(buffer);
            buffer.m_130130_(recipe.ingredientMap.size());
            recipe.ingredientMap.forEach((ingredient, count) -> {
                ingredient.m_43923_(buffer);
                buffer.m_130130_(count.intValue());
            });
        }

        private static ItemStack deserializeItem(JsonObject json) {
            return ShapedRecipe.m_151274_((JsonObject)json);
        }

        private static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
            stack.m_41663_(enchantment, level);
        }

        private static void logInvalidRecipe(TokenEnchanterRecipe recipe) {
            String msg = "Token enchanter recipe '{}' is invalid, enchantment does not exist";
            if ("tokenenchanter".equals(recipe.m_6423_().m_135827_())) {
                TokenMod.LOGGER.debug(msg, (Object)recipe.m_6423_());
            } else {
                TokenMod.LOGGER.warn(msg, (Object)recipe.m_6423_());
            }
        }
    }
}

