/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.data.recipe.LibRecipeProvider;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.api.data.TokenEnchantingRecipeBuilder;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;
import net.silentchaos512.tokenenchanter.setup.ModTags;

public class ModRecipeProvider
extends LibRecipeProvider {
    private static final Set<Enchantment> ENCHANTED_TOKEN_RECIPES_CREATED = new HashSet<Enchantment>();

    public ModRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn, "tokenenchanter");
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.registerCustomRecipe(consumer, (SimpleRecipeSerializer)ModRecipes.APPLY_ENCHANTED_TOKEN.get());
        ModRecipeProvider.registerTokenEnchanting(consumer);
        this.shapedBuilder((ItemLike)ModItems.GOLD_TOKEN, 16).patternLine("///").patternLine("lel").patternLine("///").key(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).key(Character.valueOf('l'), Tags.Items.GEMS_LAPIS).key(Character.valueOf('e'), Tags.Items.GEMS_EMERALD).build(consumer);
        TagEmptyCondition silverTagEmpty = new TagEmptyCondition(ModTags.Items.INGOTS_SILVER.f_203868_());
        NotCondition silverTagExists = new NotCondition((ICondition)silverTagEmpty);
        this.shapedBuilder((ItemLike)ModItems.SILVER_TOKEN, 16).addExtraData(json -> this.writeConditions((JsonObject)json, new ICondition[]{silverTagExists})).patternLine("///").patternLine("lel").patternLine("///").key(Character.valueOf('/'), ModTags.Items.INGOTS_SILVER).key(Character.valueOf('l'), Tags.Items.GEMS_LAPIS).key(Character.valueOf('e'), Tags.Items.GEMS_EMERALD).build(consumer);
        this.shapedBuilder((ItemLike)ModItems.SILVER_TOKEN, 8).addExtraData(json -> this.writeConditions((JsonObject)json, new ICondition[]{silverTagEmpty})).patternLine("/n/").patternLine("lel").patternLine("/n/").key(Character.valueOf('/'), Tags.Items.INGOTS_IRON).key(Character.valueOf('l'), Tags.Items.GEMS_LAPIS).key(Character.valueOf('e'), Tags.Items.GEMS_EMERALD).key(Character.valueOf('n'), Tags.Items.NUGGETS_GOLD).build(consumer, this.modId("silver_token_no_silver"));
        this.shapedBuilder((ItemLike)ModBlocks.TOKEN_ENCHANTER).patternLine(" d ").patternLine("/t/").patternLine("o#o").key(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).key(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).key(Character.valueOf('t'), ModItems.GOLD_TOKEN).key(Character.valueOf('o'), Tags.Items.OBSIDIAN).key(Character.valueOf('#'), Tags.Items.STORAGE_BLOCKS_LAPIS).build(consumer);
        this.shapedBuilder((RecipeSerializer)ModRecipes.SHAPED_XP_CRYSTAL.get(), (ItemLike)ModItems.SMALL_XP_CRYSTAL).patternLine("e").patternLine("o").patternLine("e").key(Character.valueOf('e'), Tags.Items.GEMS_EMERALD).key(Character.valueOf('o'), ModItems.GOLD_TOKEN).build(consumer);
        this.shapedBuilder((RecipeSerializer)ModRecipes.SHAPED_XP_CRYSTAL.get(), (ItemLike)ModItems.XP_CRYSTAL).patternLine(" c ").patternLine("bbb").patternLine(" c ").key(Character.valueOf('c'), ModItems.SMALL_XP_CRYSTAL).key(Character.valueOf('b'), (ItemLike)Items.f_42593_).build(consumer);
        this.shapedBuilder((RecipeSerializer)ModRecipes.SHAPED_XP_CRYSTAL.get(), (ItemLike)ModItems.LARGE_XP_CRYSTAL).patternLine(" c ").patternLine("ene").patternLine(" c ").key(Character.valueOf('c'), ModItems.XP_CRYSTAL).key(Character.valueOf('e'), (ItemLike)Items.f_42545_).key(Character.valueOf('n'), Tags.Items.NETHER_STARS).build(consumer);
    }

    private static void registerTokenEnchanting(Consumer<FinishedRecipe> consumer) {
        TokenEnchantingRecipeBuilder.builder((ItemLike)Items.f_42436_, 1, 2).token((ItemLike)Items.f_42410_).addIngredient((TagKey<Item>)Tags.Items.INGOTS_GOLD, 6).build(consumer, TokenMod.getId("golden_apple"));
        TokenEnchantingRecipeBuilder.builder(ModItems.XP_BREAD, 1, 10).infuseLevels(8).token((ItemLike)Items.f_42406_).addIngredient((ItemLike)Items.f_42787_, 1).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44971_, 2).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, 1).addIngredient((ItemLike)Items.f_42526_, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44979_, 2).addIngredient((TagKey<Item>)Tags.Items.NUGGETS_IRON, 6).addIngredient((ItemLike)Items.f_42591_, 6).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44968_, 2).addIngredient((TagKey<Item>)Tags.Items.INGOTS_BRICK, 8).addIngredient((TagKey<Item>)Tags.Items.GUNPOWDER, 6).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44958_, 4).addIngredient((ItemLike)Items.f_42715_, 1).addIngredient((TagKey<Item>)Tags.Items.INGOTS_GOLD, 12).addIngredient((ItemLike)Items.f_42545_, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44973_, 6).addIngredient((ItemLike)Items.f_41955_, 1).addIngredient((ItemLike)Items.f_41983_, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44984_, 2).addIngredient((TagKey<Item>)Tags.Items.NUGGETS_GOLD, 4).addIngredient((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, 9).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44967_, 3).addIngredient((TagKey<Item>)ItemTags.f_13167_, 5).addIngredient((TagKey<Item>)Tags.Items.FEATHERS, 10).addIngredient((TagKey<Item>)Tags.Items.SLIMEBALLS, 2).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44981_, 5).addIngredient((ItemLike)Items.f_42542_, 6).addIngredient((TagKey<Item>)Tags.Items.NETHERRACK, 30).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44966_, 2).addIngredient((ItemLike)Items.f_41981_, 5).addIngredient((TagKey<Item>)Tags.Items.INGOTS_NETHER_BRICK, 20).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44990_, 5).addIngredient((TagKey<Item>)Tags.Items.RODS_BLAZE, 3).addIngredient((TagKey<Item>)Tags.Items.NETHERRACK, 30).addIngredient((ItemLike)Items.f_42412_, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44987_, 6).addIngredient((TagKey<Item>)Tags.Items.GEMS_DIAMOND, 3).addIngredient((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, 16).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44974_, 32).addIngredient((ItemLike)Items.f_42363_, 4).addIngredient((TagKey<Item>)Tags.Items.GEMS_PRISMARINE, 16).addIngredient((ItemLike)Items.f_42004_, 64).addIngredient((ItemLike)Items.f_42755_, 32).addIngredient((ItemLike)Items.f_42258_, 32).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44956_, 3).addIngredient((ItemLike)Items.f_42715_, 1).addIngredient((ItemLike)Items.f_42383_, 1).addIngredient((TagKey<Item>)Tags.Items.DUSTS_PRISMARINE, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44952_, 16).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD, 1).addIngredient((ItemLike)Items.f_42545_, 4).addIngredient((ItemLike)Items.f_42412_, 64).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44980_, 1).addIngredient((ItemLike)Items.f_41869_, 2).addIngredient((TagKey<Item>)Tags.Items.FEATHERS, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44982_, 8).addIngredient((TagKey<Item>)Tags.Items.GEMS_EMERALD, 2).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, 3).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44955_, 6).addIngredient((ItemLike)Items.f_42715_, 1).addIngredient((ItemLike)Items.f_42026_, 12).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44953_, 2).addIngredient((ItemLike)Items.f_42526_, 7).addIngredient((ItemLike)Items.f_41910_, 7).addIngredient((ItemLike)Items.f_41867_, 7).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44954_, 2).addIngredient((ItemLike)Items.f_42109_, 4).addIngredient((ItemLike)Items.f_42527_, 6).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44962_, 32).addIngredient((TagKey<Item>)Tags.Items.INGOTS_NETHERITE, 1).addIngredient((ItemLike)Items.f_42410_, 64).addIngredient((ItemLike)Items.f_41908_, 16).addIngredient((ItemLike)Items.f_41954_, 4).addIngredient((ItemLike)Items.f_42730_, 32).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44959_, 16).addIngredient((ItemLike)Items.f_42717_, 1).addIngredient((ItemLike)Items.f_42109_, 12).addIngredient((TagKey<Item>)Tags.Items.ENDER_PEARLS, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44961_, 2).addIngredient((ItemLike)Items.f_42717_, 1).addIngredient((ItemLike)Items.f_42025_, 12).addIngredient((TagKey<Item>)Tags.Items.INGOTS_GOLD, 1).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44988_, 2).addIngredient((ItemLike)Items.f_42412_, 10).addIngredient((TagKey<Item>)Tags.Items.STRING, 5).addIngredient((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44969_, 2).addIngredient((TagKey<Item>)Tags.Items.INGOTS_IRON, 4).addIngredient((ItemLike)Items.f_42026_, 2).addIngredient((ItemLike)Items.f_42412_, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44965_, 2).addIngredient((ItemLike)Items.f_42025_, 4).addIngredient((TagKey<Item>)Tags.Items.INGOTS_BRICK, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44989_, 1).addIngredient((ItemLike)Items.f_41869_, 2).addIngredient((ItemLike)Items.f_42412_, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44960_, 4).addIngredient((ItemLike)Items.f_42717_, 1).addIngredient((TagKey<Item>)Tags.Items.INGOTS_GOLD, 2).addIngredient((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, 16).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44970_, 4).addIngredient((ItemLike)Items.f_42529_, 2).addIngredient((ItemLike)Items.f_42590_, 9).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44957_, 6).addIngredient((ItemLike)Items.f_42715_, 1).addIngredient((TagKey<Item>)Tags.Items.FEATHERS, 20).addIngredient((TagKey<Item>)Tags.Items.GEMS_LAPIS, 5).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44977_, 3).addIngredient((TagKey<Item>)Tags.Items.INGOTS_IRON, 1).addIngredient((ItemLike)Items.f_42484_, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44985_, 12).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD, 1).addIngredient((TagKey<Item>)Tags.Items.RODS_BLAZE, 4).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44978_, 2).addIngredient((TagKey<Item>)Tags.Items.GEMS_LAPIS, 2).addIngredient((ItemLike)Items.f_42583_, 15).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44976_, 4).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ, 1).addIngredient((ItemLike)Items.f_42050_, 20).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44983_, 1).addIngredient((ItemLike)Items.f_42026_, 2).addIngredient((ItemLike)Items.f_41909_, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44972_, 3).addIngredient((ItemLike)Items.f_42025_, 12).addIngredient((ItemLike)Items.f_42208_, 8).build(consumer);
        ModRecipeProvider.enchantedToken(Enchantments.f_44986_, 1).addIngredient((TagKey<Item>)Tags.Items.INGOTS_IRON, 6).addIngredient((TagKey<Item>)Tags.Items.COBBLESTONE, 12).build(consumer);
        ModRecipeProvider.createCursedTokenRecipe(consumer, Enchantments.f_44975_, (TagKey<Item>)Tags.Items.STRING);
        ModRecipeProvider.createCursedTokenRecipe(consumer, Enchantments.f_44963_, (TagKey<Item>)Tags.Items.GUNPOWDER);
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            ResourceLocation id = NameUtils.from((IForgeRegistryEntry)enchantment);
            if (!"minecraft".equals(id.m_135827_()) || ENCHANTED_TOKEN_RECIPES_CREATED.contains(enchantment)) continue;
            throw new NullPointerException("Missing enchanted token recipe for '" + id + "'");
        }
    }

    private static TokenEnchantingRecipeBuilder enchantedToken(Enchantment enchantment, int levelCost) {
        ENCHANTED_TOKEN_RECIPES_CREATED.add(enchantment);
        return TokenEnchantingRecipeBuilder.enchantedTokenBuilder(enchantment, 1, 1, levelCost).name(ModRecipeProvider.getEnchantedTokenRecipeId(enchantment));
    }

    private static void createCursedTokenRecipe(Consumer<FinishedRecipe> consumer, Enchantment enchantment, TagKey<Item> ingredient) {
        ENCHANTED_TOKEN_RECIPES_CREATED.add(enchantment);
        TokenEnchantingRecipeBuilder.builder(ModItems.ENCHANTED_TOKEN, 1, 1).enchantment(enchantment, 1).token(ModTags.Items.TOKENS_SILVER).addIngredient(ingredient, 4).build(consumer, ModRecipeProvider.getEnchantedTokenRecipeId(enchantment));
    }

    private static ResourceLocation getEnchantedTokenRecipeId(Enchantment enchantment) {
        ResourceLocation enchantmentId = NameUtils.from((IForgeRegistryEntry)enchantment);
        return TokenMod.getId(String.format("enchanted_token/%s.%s", enchantmentId.m_135827_(), enchantmentId.m_135815_()));
    }

    protected void writeConditions(JsonObject json, ICondition ... conditions) {
        if (conditions.length > 0) {
            JsonArray array = new JsonArray();
            for (ICondition condition : conditions) {
                array.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)array);
        }
    }
}

