/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageItemImpl;
import net.silentchaos512.tokenenchanter.util.TextUtil;

public class XpFoodItem
extends Item {
    public XpFoodItem(Item.Properties properties) {
        super(properties);
        if (!this.m_41472_()) {
            throw new IllegalArgumentException("XpFoodItem must be a food");
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == XpStorageCapability.INSTANCE) {
                    return LazyOptional.of(() -> new XpStorageItemImpl(stack, Integer.MAX_VALUE, false)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            float levels = stack.getCapability(XpStorageCapability.INSTANCE).map(IXpStorage::getLevels).orElse(Float.valueOf(0.0f)).floatValue();
            ((Player)entityLiving).m_6749_(Math.round(levels));
        }
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        float levels = stack.getCapability(XpStorageCapability.INSTANCE).map(IXpStorage::getLevels).orElse(Float.valueOf(0.0f)).floatValue();
        tooltip.add(TextUtil.translate("item", "xp_food.levels", Float.valueOf(levels)));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)this.createWithLevels(5));
            items.add((Object)this.createWithLevels(10));
            items.add((Object)this.createWithLevels(20));
            items.add((Object)this.createWithLevels(30));
        }
    }

    public ItemStack createWithLevels(int levels) {
        ItemStack ret = new ItemStack((ItemLike)this);
        ret.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.setLevels(levels));
        return ret;
    }
}

