/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.silentchaos512.lib.data.recipe.DamageItemRecipeBuilder;
import net.silentchaos512.lib.data.recipe.ExtendedShapedRecipeBuilder;
import net.silentchaos512.lib.data.recipe.ExtendedShapelessRecipeBuilder;
import net.silentchaos512.lib.util.NameUtils;

public abstract class LibRecipeProvider
extends RecipeProvider {
    private final String modId;

    public LibRecipeProvider(DataGenerator generatorIn, String modId) {
        super(generatorIn);
        this.modId = modId;
    }

    protected abstract void m_176531_(Consumer<FinishedRecipe> var1);

    protected ResourceLocation modId(String path) {
        return new ResourceLocation(this.modId, path);
    }

    protected void writeConditions(JsonObject json, ICondition ... conditions) {
        if (conditions.length > 0) {
            JsonArray array = new JsonArray();
            for (ICondition condition : conditions) {
                array.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)array);
        }
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(ItemLike result) {
        return ExtendedShapedRecipeBuilder.vanillaBuilder(result, 1);
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(ItemLike result, int count) {
        return ExtendedShapedRecipeBuilder.vanillaBuilder(result, count);
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(RecipeSerializer<?> serializer, ItemLike result) {
        return ExtendedShapedRecipeBuilder.builder(serializer, result, 1);
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return ExtendedShapedRecipeBuilder.builder(serializer, result, count);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(ItemLike result) {
        return ExtendedShapelessRecipeBuilder.vanillaBuilder(result, 1);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(ItemLike result, int count) {
        return ExtendedShapelessRecipeBuilder.vanillaBuilder(result, count);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(RecipeSerializer<?> serializer, ItemLike result) {
        return ExtendedShapelessRecipeBuilder.builder(serializer, result, 1);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return ExtendedShapelessRecipeBuilder.builder(serializer, result, count);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(ItemLike result) {
        return DamageItemRecipeBuilder.builder(result, 1);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(ItemLike result, int count) {
        return DamageItemRecipeBuilder.builder(result, count);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(RecipeSerializer<?> serializer, ItemLike result) {
        return DamageItemRecipeBuilder.builder(serializer, result, 1);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return DamageItemRecipeBuilder.builder(serializer, result, count);
    }

    protected void registerCustomRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer) {
        this.registerCustomRecipe(consumer, serializer, NameUtils.fromRecipeSerializer(serializer));
    }

    protected void registerCustomRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer, ResourceLocation recipeId) {
        SpecialRecipeBuilder.m_126357_(serializer).m_126359_(consumer, recipeId.toString());
    }

    protected void smeltingAndBlastingRecipes(Consumer<FinishedRecipe> consumer, String id, ItemLike ingredientIn, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredientIn}), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(Consumer<FinishedRecipe> consumer, String id, TagKey<Item> ingredientIn, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.m_204132_(ingredientIn), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(Consumer<FinishedRecipe> consumer, String id, Ingredient ingredientIn, ItemLike result, float experienceIn) {
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)ingredientIn, (ItemLike)result, (float)experienceIn, (int)100).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_126140_(consumer, this.modId("blasting/" + id));
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)ingredientIn, (ItemLike)result, (float)experienceIn, (int)200).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_126140_(consumer, this.modId("smelting/" + id));
    }

    protected void compressionRecipes(Consumer<FinishedRecipe> consumer, ItemLike block, ItemLike item, @Nullable ItemLike nugget) {
        String blockName = NameUtils.fromItem(block).m_135815_();
        String itemName = NameUtils.fromItem(item).m_135815_();
        ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), item).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(itemName + "_from_block"));
        ShapelessRecipeBuilder.m_126191_((ItemLike)item, (int)9).m_126209_(block).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(blockName));
        if (nugget != null) {
            String nuggetName = NameUtils.fromItem(nugget).m_135815_();
            ShapedRecipeBuilder.m_126118_((ItemLike)item, (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), nugget).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(itemName + "_from_nugget"));
            ShapelessRecipeBuilder.m_126191_((ItemLike)nugget, (int)9).m_126209_(item).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(nuggetName));
        }
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> p_206407_) {
        return LibRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(p_206407_).m_45077_()});
    }
}

