/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.LootUtils;
import net.silentchaos512.lib.util.PlayerUtils;

public class LootContainerItem
extends Item {
    private static final String NBT_ROOT = "silentlib.LootContainer";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private static final boolean DEFAULT_LIST_ITEMS_RECEIVED = true;
    private final ResourceLocation defaultLootTable;
    private final boolean listItemsReceived;

    public LootContainerItem(ResourceLocation defaultLootTable) {
        this(defaultLootTable, true, new Item.Properties());
    }

    public LootContainerItem(ResourceLocation defaultLootTable, boolean listItemsReceived) {
        this(defaultLootTable, listItemsReceived, new Item.Properties());
    }

    public LootContainerItem(ResourceLocation defaultLootTable, Item.Properties properties) {
        this(defaultLootTable, true, properties);
    }

    public LootContainerItem(ResourceLocation defaultLootTable, boolean listItemsReceived, Item.Properties properties) {
        super(properties);
        this.defaultLootTable = defaultLootTable;
        this.listItemsReceived = listItemsReceived;
    }

    public ItemStack getStack() {
        return this.getStack(this.defaultLootTable);
    }

    public ItemStack getStack(ResourceLocation lootTable) {
        ItemStack result = new ItemStack((ItemLike)this);
        LootContainerItem.getData(result).m_128359_(NBT_LOOT_TABLE, lootTable.toString());
        return result;
    }

    protected static CompoundTag getData(ItemStack stack) {
        return stack.m_41698_(NBT_ROOT);
    }

    protected ResourceLocation getLootTable(ItemStack stack) {
        String str;
        ResourceLocation table;
        CompoundTag tags = LootContainerItem.getData(stack);
        if (tags.m_128441_(NBT_LOOT_TABLE) && (table = ResourceLocation.m_135820_((String)(str = tags.m_128461_(NBT_LOOT_TABLE)))) != null) {
            return table;
        }
        return this.defaultLootTable;
    }

    public static void setLootTable(ItemStack stack, ResourceLocation lootTable) {
        LootContainerItem.getData(stack).m_128359_(NBT_LOOT_TABLE, lootTable.toString());
    }

    protected Collection<ItemStack> getLootDrops(ItemStack heldItem, ServerPlayer player) {
        return LootUtils.gift(this.getLootTable(heldItem), player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!flagIn.m_7050_()) {
            return;
        }
        MutableComponent textTableName = Component.m_237113_((String)this.getLootTable(stack).toString()).m_130940_(ChatFormatting.WHITE);
        tooltip.add((Component)Component.m_237110_((String)"item.silentlib.lootContainer.table", (Object[])new Object[]{textTableName}).m_130940_(ChatFormatting.BLUE));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        if (!(playerIn instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        ServerPlayer playerMP = (ServerPlayer)playerIn;
        Collection<ItemStack> lootDrops = this.getLootDrops(heldItem, playerMP);
        if (lootDrops.isEmpty()) {
            SilentLib.LOGGER.warn("LootContainerItem has no drops? {}, table={}", (Object)heldItem, (Object)this.getLootTable(heldItem));
        }
        lootDrops.forEach(stack -> {
            PlayerUtils.giveItem((Player)playerMP, stack);
            if (this.listItemsReceived) {
                LootContainerItem.listItemReceivedInChat(playerMP, stack);
            }
        });
        float pitch = ((playerMP.m_217043_().m_188501_() - playerMP.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f;
        playerMP.f_19853_.m_5594_(null, playerMP.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, pitch);
        heldItem.m_41774_(1);
        return InteractionResultHolder.m_19090_((Object)heldItem);
    }

    private static void listItemReceivedInChat(ServerPlayer playerMP, ItemStack stack) {
        MutableComponent itemReceivedText = Component.m_237110_((String)"item.silentlib.lootContainer.itemReceived", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_()});
        playerMP.m_213846_((Component)itemReceivedText);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.getStack());
        }
    }
}

