/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterContainerScreen;
import net.silentchaos512.tokenenchanter.crafting.recipe.TokenEnchanterRecipe;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.util.TextUtil;

public class TokenEnchantingRecipeCategoryJei
implements IRecipeCategory<TokenEnchanterRecipe> {
    public static final RecipeType<TokenEnchanterRecipe> RECIPE_TYPE = RecipeType.create((String)"tokenenchanter", (String)"token_enchanting", TokenEnchanterRecipe.class);
    private static final int GUI_START_X = 21;
    private static final int GUI_START_Y = 24;
    private static final int GUI_WIDTH = 134;
    private static final int GUI_HEIGHT = 50;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public TokenEnchantingRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TokenEnchanterContainerScreen.TEXTURE, 21, 24, 134, 50);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.TOKEN_ENCHANTER));
        this.localizedName = Component.m_237115_((String)"category.tokenenchanter.token_enchanting");
    }

    public RecipeType<TokenEnchanterRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TokenEnchanterRecipe recipe, IFocusGroup focuses) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        recipe.getIngredientMap().forEach((ingredient, count) -> {
            List<ItemStack> list = Arrays.asList(ingredient.m_43908_());
            list.forEach(stack -> stack.m_41764_(count.intValue()));
            inputs.add(list);
        });
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 30).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, TokenEnchantingRecipeCategoryJei.getXpCrystals(recipe));
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 10).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getToken().m_43908_()));
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 0).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, TokenEnchantingRecipeCategoryJei.getStacksOrEmptyList(inputs, 0));
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 0).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, TokenEnchantingRecipeCategoryJei.getStacksOrEmptyList(inputs, 1));
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 0).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, TokenEnchantingRecipeCategoryJei.getStacksOrEmptyList(inputs, 2));
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 18).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, TokenEnchantingRecipeCategoryJei.getStacksOrEmptyList(inputs, 3));
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 18).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, TokenEnchantingRecipeCategoryJei.getStacksOrEmptyList(inputs, 4));
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 18).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, TokenEnchantingRecipeCategoryJei.getStacksOrEmptyList(inputs, 5));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 111, 10).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(recipe.getResult()));
    }

    private static List<ItemStack> getStacksOrEmptyList(List<List<ItemStack>> list, int index) {
        if (index < 0 || index >= list.size()) {
            return Collections.emptyList();
        }
        return list.get(index);
    }

    private static List<ItemStack> getXpCrystals(TokenEnchanterRecipe recipe) {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(stack -> {
            IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
            return xp.canDrain() && xp.getCapacity() >= recipe.getLevelCost();
        }).map(TokenEnchantingRecipeCategoryJei::getFullCrystal).collect(Collectors.toList());
    }

    private static ItemStack getFullCrystal(ItemStack stack) {
        stack.getCapability(XpStorageCapability.INSTANCE).ifPresent(xp -> xp.addLevels(xp.getCapacity()));
        return stack;
    }

    public void draw(TokenEnchanterRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        Component text = TextUtil.translate("misc", "level_cost", recipe.getLevelCost());
        String string = text.getString();
        Objects.requireNonNull(font);
        font.m_92750_(stack, string, 25.0f, (float)(50 - 9 - 1), -1);
    }
}

