/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public class TextUtils {
    public static String lower(String str) {
        return str.toLowerCase(Locale.ROOT);
    }

    public static List<String> wrapLines(Iterable<String> list, int lineWidth, Function<String, String> stripper) {
        ArrayList<String> result = new ArrayList<String>();
        for (String str : list) {
            String format = stripper.apply(str);
            String[] split = new String[]{};
            while (str.length() > lineWidth && split.length != 1) {
                split = TextUtils.splitLine(str, lineWidth);
                result.add(format + split[0]);
                if (split.length <= 1) continue;
                str = split[1];
            }
            if (split.length == 1) continue;
            result.add(format + str);
        }
        return result;
    }

    private static String[] splitLine(String str, int lineWidth) {
        if (str.length() <= lineWidth) {
            return new String[]{str};
        }
        for (int c = lineWidth; c < str.length(); ++c) {
            if (!Character.isWhitespace(str.charAt(c))) continue;
            return new String[]{str.substring(0, c), str.substring(c + 1)};
        }
        return new String[]{str};
    }
}

