/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.config.ModConfig;
import net.silentchaos512.tokenenchanter.item.HasSubItems;
import net.silentchaos512.tokenenchanter.setup.ModItems;
import net.silentchaos512.tokenenchanter.setup.Registration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tokenenchanter")
@Mod.EventBusSubscriber(modid="tokenenchanter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TokenMod {
    public static final String MOD_ID = "tokenenchanter";
    public static final Random RANDOM = new Random();
    public static final Logger LOGGER = LogManager.getLogger((String)"Token Enchanter");
    @Nullable
    private static CreativeModeTab creativeModeTab;

    public TokenMod() {
        Registration.register();
        ModConfig.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TokenMod::onRegisterCreativeTab);
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IXpStorage.class);
    }

    private static void onRegisterCreativeTab(CreativeModeTabEvent.Register event) {
        creativeModeTab = event.registerCreativeModeTab(TokenMod.getId("tab"), b -> b.m_257737_(() -> new ItemStack((ItemLike)ModItems.GOLD_TOKEN.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.tokenenchanter")).m_257501_((itemDisplayParameters, output) -> Registration.ITEMS.getEntries().forEach(ro -> {
            Item item = (Item)ro.get();
            if (item instanceof HasSubItems) {
                output.m_246601_(((HasSubItems)item).getSubItems());
            } else {
                output.m_246326_((ItemLike)item);
            }
        })).m_257652_());
    }

    public static String getVersion() {
        Optional o = ModList.get().getModContainerById(MOD_ID);
        if (o.isPresent()) {
            return ((ModContainer)o.get()).getModInfo().getVersion().toString();
        }
        return "0.0.0";
    }

    public static boolean isDevBuild() {
        return "NONE".equals(TokenMod.getVersion());
    }

    public static ResourceLocation getId(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @Nullable
    public static ResourceLocation getIdWithDefaultNamespace(String name) {
        if (name.contains(":")) {
            return ResourceLocation.m_135820_((String)name);
        }
        return ResourceLocation.m_135820_((String)("tokenenchanter:" + name));
    }

    public static String shortenId(@Nullable ResourceLocation id) {
        if (id == null) {
            return "null";
        }
        if (MOD_ID.equals(id.m_135827_())) {
            return id.m_135815_();
        }
        return id.toString();
    }
}

