/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.block.tokenenchanter;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.tokenenchanter.api.xp.IXpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorage;
import net.silentchaos512.tokenenchanter.api.xp.XpStorageCapability;
import net.silentchaos512.tokenenchanter.block.tokenenchanter.TokenEnchanterContainerMenu;
import net.silentchaos512.tokenenchanter.crafting.recipe.TokenEnchanterRecipe;
import net.silentchaos512.tokenenchanter.setup.ModBlockEntityTypes;
import net.silentchaos512.tokenenchanter.setup.ModBlocks;
import net.silentchaos512.tokenenchanter.setup.ModRecipes;

public class TokenEnchanterBlockEntity
extends LockableSidedInventoryTileEntity {
    public static final int PROCESS_TIME = 50;
    private static final int INVENTORY_SIZE = 9;
    private static final int[] SLOTS_INPUT = IntStream.range(1, 8).toArray();
    private static final int[] SLOTS_OUTPUT = new int[]{8};
    private static final int[] SLOTS_ALL = IntStream.range(0, 9).toArray();
    private int progress;
    private final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TokenEnchanterBlockEntity.this.progress;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TokenEnchanterBlockEntity.this.progress = value;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public TokenEnchanterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TOKEN_ENCHANTER.get(), 9, pos, state);
    }

    TokenEnchanterBlockEntity() {
        super((BlockEntityType)ModBlockEntityTypes.TOKEN_ENCHANTER.get(), 9, BlockPos.f_121853_, ModBlocks.TOKEN_ENCHANTER.asBlockState());
    }

    @Nullable
    private TokenEnchanterRecipe getRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipes.TOKEN_ENCHANTING_TYPE.get(), (Container)this, this.f_58857_).orElse(null);
    }

    private ItemStack getCraftingResult(TokenEnchanterRecipe recipe) {
        return recipe.m_5874_((Container)this, null);
    }

    private void consumeIngredients(TokenEnchanterRecipe recipe) {
        recipe.consumeIngredients((Container)this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TokenEnchanterBlockEntity blockEntity) {
        TokenEnchanterRecipe recipe = blockEntity.getRecipe();
        if (recipe != null && blockEntity.canMachineRun(recipe)) {
            ++blockEntity.progress;
            if (blockEntity.progress >= 50) {
                blockEntity.storeResultItem(blockEntity.getCraftingResult(recipe));
                blockEntity.consumeIngredients(recipe);
                blockEntity.progress = 0;
            }
        } else {
            blockEntity.progress = 0;
        }
    }

    private boolean canMachineRun(TokenEnchanterRecipe recipe) {
        return this.f_58857_ != null && recipe.m_5818_((Container)this, this.f_58857_) && this.hasRoomForOutputItem(this.getCraftingResult(recipe));
    }

    private boolean hasRoomForOutputItem(ItemStack stack) {
        return TokenEnchanterBlockEntity.canItemsStack(stack, this.m_8020_(8));
    }

    private static boolean canItemsStack(ItemStack a, ItemStack b) {
        if (a.m_41619_() || b.m_41619_()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) && a.m_41613_() + b.m_41613_() <= a.m_41741_();
    }

    private void storeResultItem(ItemStack stack) {
        ItemStack output = this.m_8020_(8);
        if (TokenEnchanterBlockEntity.canItemsStack(stack, output)) {
            if (output.m_41619_()) {
                this.m_6836_(8, stack);
            } else {
                output.m_41764_(output.m_41613_() + stack.m_41613_());
            }
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.tokenenchanter.token_enchanter");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new TokenEnchanterContainerMenu(id, playerInventory, this, this.fields);
    }

    public int[] m_7071_(Direction side) {
        switch (side) {
            case UP: {
                return SLOTS_INPUT;
            }
            case DOWN: {
                return SLOTS_ALL;
            }
        }
        return SLOTS_ALL;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 8;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            IXpStorage xp = (IXpStorage)stack.getCapability(XpStorageCapability.INSTANCE).orElse((Object)XpStorage.INVALID);
            return xp.canDrain();
        }
        return index < 8;
    }
}

