/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.item;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.item.HasSubItems;

public class EnchantedTokenItem
extends Item
implements HasSubItems {
    public static final ResourceLocation MODEL_INDEX = TokenMod.getId("model_index");
    private static final Map<Enchantment, Integer> OUTLINE_COLOR_MAP = new HashMap<Enchantment, Integer>();
    private static final Map<String, Icon> MODELS_BY_TYPE = new HashMap<String, Icon>();
    private static final float OUTLINE_PULSATE_SPEED = 0.10610329f;

    public EnchantedTokenItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack construct(Enchantment enchantment, int level) {
        return this.construct(new EnchantmentInstance(enchantment, level));
    }

    public ItemStack construct(EnchantmentInstance ... enchantments) {
        ItemStack stack = new ItemStack((ItemLike)this);
        for (EnchantmentInstance data : enchantments) {
            EnchantedTokenItem.addEnchantment(stack, data);
        }
        return stack;
    }

    public static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
        EnchantedTokenItem.addEnchantment(stack, new EnchantmentInstance(enchantment, level));
    }

    private static void addEnchantment(ItemStack stack, EnchantmentInstance data) {
        stack.m_41663_(data.f_44947_, data.f_44948_);
    }

    public static ItemStack applyTokenToItem(ItemStack token, ItemStack stack) {
        if (stack.m_41619_()) {
            return stack;
        }
        if (stack.m_41720_() == Items.f_42517_ || stack.m_41720_() == Items.f_42690_) {
            return EnchantedTokenItem.applyTokenToBook(token, stack);
        }
        return EnchantedTokenItem.applyTokenToTool(token, stack);
    }

    public static ItemStack applyTokenToBook(ItemStack token, ItemStack book) {
        ItemStack ret = book.m_41720_() == Items.f_42517_ ? new ItemStack((ItemLike)Items.f_42690_) : book.m_41777_();
        Map enchantmentsOnToken = EnchantmentHelper.m_44831_((ItemStack)token);
        if (enchantmentsOnToken.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Map enchantmentsOnBook = EnchantmentHelper.m_44831_((ItemStack)ret);
        if (!EnchantedTokenItem.mergeEnchantmentLists(enchantmentsOnToken, enchantmentsOnBook)) {
            return ItemStack.f_41583_;
        }
        EnchantmentHelper.m_44865_((Map)enchantmentsOnToken, (ItemStack)ret);
        return ret;
    }

    public static ItemStack applyTokenToTool(ItemStack token, ItemStack tool) {
        if (token.m_41619_() || tool.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Map enchantmentsOnToken = EnchantmentHelper.m_44831_((ItemStack)token);
        if (enchantmentsOnToken.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Map enchantmentsOnTool = EnchantmentHelper.m_44831_((ItemStack)tool);
        for (Map.Entry entry : enchantmentsOnToken.entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            if (!ench.m_6081_(tool)) {
                return ItemStack.f_41583_;
            }
            for (Enchantment enchTool : enchantmentsOnTool.keySet()) {
                if (ench.equals(enchTool) || ench.m_44695_(enchTool)) continue;
                return ItemStack.f_41583_;
            }
        }
        if (!EnchantedTokenItem.mergeEnchantmentLists(enchantmentsOnToken, enchantmentsOnTool)) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = tool.m_41777_();
        EnchantmentHelper.m_44865_((Map)enchantmentsOnToken, (ItemStack)ret);
        return ret;
    }

    private static boolean mergeEnchantmentLists(Map<Enchantment, Integer> first, Map<Enchantment, Integer> second) {
        for (Enchantment enchantment : second.keySet()) {
            int newLevel;
            int level = newLevel = second.get(enchantment).intValue();
            if (first.containsKey(enchantment) && (newLevel = first.get(enchantment) + level) > enchantment.m_6586_()) {
                return false;
            }
            first.put(enchantment, newLevel);
        }
        return true;
    }

    public Component m_7626_(ItemStack stack) {
        Enchantment enchantment = EnchantedTokenItem.getSingleEnchantment(stack);
        if (enchantment != null) {
            MutableComponent enchantmentName = enchantment.m_44700_(1).m_6879_().m_130938_(this.m_41460_(stack).getStyleModifier());
            return Component.m_237110_((String)(this.m_5671_(stack) + ".single"), (Object[])new Object[]{enchantmentName});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.size() == 1) {
            Enchantment enchantment = (Enchantment)enchantments.keySet().iterator().next();
            list.add(this.subText("maxLevel", enchantment.m_6586_()));
            list.add(this.subText("mod", EnchantedTokenItem.getModName(enchantment)));
            if (flag.m_7050_()) {
                ResourceLocation registryName = NameUtils.fromEnchantment((Enchantment)enchantment);
                list.add((Component)Component.m_237113_((String)registryName.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    private static String getModName(Enchantment enchantment) {
        return ModList.get().getModContainerById(NameUtils.fromEnchantment((Enchantment)enchantment).m_135827_()).map(c -> c.getModInfo().getDisplayName()).orElse("Unknown Mod");
    }

    private Component subText(String key, Object ... formatArgs) {
        ResourceLocation id = NameUtils.fromItem((ItemLike)this);
        String fullKey = String.format("item.%s.%s.%s", id.m_135827_(), id.m_135815_(), key);
        return Component.m_237110_((String)fullKey, (Object[])formatArgs);
    }

    @Override
    public List<ItemStack> getSubItems() {
        NonNullList tokens = NonNullList.m_122779_();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            tokens.add((Object)this.construct(enchantment, 1));
        }
        tokens.sort(EnchantedTokenItem::compareEnchantmentNames);
        return tokens;
    }

    private static int compareEnchantmentNames(ItemStack o1, ItemStack o2) {
        int k = Integer.compare(EnchantedTokenItem.getModelIcon(o1).ordinal(), EnchantedTokenItem.getModelIcon(o2).ordinal());
        if (k == 0) {
            Enchantment e1 = EnchantedTokenItem.getSingleEnchantment(o1);
            Enchantment e2 = EnchantedTokenItem.getSingleEnchantment(o2);
            if (e1 != null && e2 != null) {
                Component name1 = EnchantedTokenItem.getEnchantmentDisplayName(e1);
                Component name2 = EnchantedTokenItem.getEnchantmentDisplayName(e2);
                return name1.getString().compareTo(name2.getString());
            }
        }
        return k;
    }

    private static Component getEnchantmentDisplayName(Enchantment enchantment) {
        try {
            return enchantment.m_44700_(1);
        }
        catch (Throwable ex) {
            CrashReport report = CrashReport.m_127521_((Throwable)ex, (String)"Enchantment threw an exception when getting display name. This is not Token Enchanter's fault!");
            CrashReportCategory cat = report.m_127514_("Enchantment");
            cat.m_128159_("ID", (Object)NameUtils.fromEnchantment((Enchantment)enchantment));
            cat.m_128159_("Mod Name", (Object)EnchantedTokenItem.getModName(enchantment));
            throw new ReportedException(report);
        }
    }

    @Nullable
    public static Enchantment getSingleEnchantment(ItemStack token) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)token);
        if (map.size() != 1) {
            return null;
        }
        return (Enchantment)map.keySet().iterator().next();
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        int baseColor = EnchantedTokenItem.getOutlineColor(stack);
        int j = (int)(160.0f * Mth.m_14031_((float)((float)ClientTicks.ticksInGame() * 0.10610329f)));
        j = Mth.m_14045_((int)j, (int)0, (int)255);
        int r = baseColor >> 16 & 0xFF;
        r = Mth.m_14045_((int)(r + j), (int)0, (int)255);
        int g = baseColor >> 8 & 0xFF;
        g = Mth.m_14045_((int)(g + j), (int)0, (int)255);
        int b = baseColor & 0xFF;
        b = Mth.m_14045_((int)(b + j), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    private static int getOutlineColor(ItemStack stack) {
        Enchantment enchantment = EnchantedTokenItem.getSingleEnchantment(stack);
        if (enchantment != null) {
            return OUTLINE_COLOR_MAP.computeIfAbsent(enchantment, e -> {
                int hash = NameUtils.fromEnchantment((Enchantment)e).hashCode();
                float hue = (float)((hash + 32 * OUTLINE_COLOR_MAP.size()) % 1024) / 1024.0f;
                return Color.getHSBColor(hue, 1.0f, 1.0f).getRGB();
            });
        }
        return 8405196;
    }

    public static float getModel(ItemStack stack, ClientLevel world, LivingEntity entity, int var4) {
        return EnchantedTokenItem.getModelIcon(stack).ordinal();
    }

    private static Icon getModelIcon(ItemStack stack) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (map.isEmpty()) {
            return Icon.UNKNOWN;
        }
        Enchantment enchantment = (Enchantment)map.keySet().iterator().next();
        if (enchantment.m_6589_()) {
            return Icon.CURSE;
        }
        EnchantmentCategory type = enchantment.f_44672_;
        if (type == null) {
            return Icon.UNKNOWN;
        }
        return MODELS_BY_TYPE.getOrDefault(type.toString(), Icon.UNKNOWN);
    }

    static {
        MODELS_BY_TYPE.put(EnchantmentCategory.VANISHABLE.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnchantmentCategory.BREAKABLE.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnchantmentCategory.ARMOR.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentCategory.ARMOR_CHEST.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentCategory.ARMOR_FEET.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentCategory.ARMOR_HEAD.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentCategory.ARMOR_LEGS.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentCategory.WEARABLE.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentCategory.BOW.toString(), Icon.BOW);
        MODELS_BY_TYPE.put(EnchantmentCategory.CROSSBOW.toString(), Icon.CROSSBOW);
        MODELS_BY_TYPE.put(EnchantmentCategory.DIGGER.toString(), Icon.TOOL);
        MODELS_BY_TYPE.put(EnchantmentCategory.FISHING_ROD.toString(), Icon.FISHING_ROD);
        MODELS_BY_TYPE.put(EnchantmentCategory.TRIDENT.toString(), Icon.TRIDENT);
        MODELS_BY_TYPE.put(EnchantmentCategory.WEAPON.toString(), Icon.SWORD);
        if (TokenMod.isDevBuild()) {
            TokenMod.LOGGER.info("Checking enchantment type icons...");
            boolean allGood = true;
            for (EnchantmentCategory type : EnchantmentCategory.values()) {
                if (MODELS_BY_TYPE.containsKey(type.toString())) continue;
                TokenMod.LOGGER.fatal("Missing icon for type: {}", (Object)type);
                allGood = false;
            }
            if (allGood) {
                TokenMod.LOGGER.info("All good!");
            }
        }
    }

    public static enum Icon {
        ANY,
        TOOL,
        SWORD,
        FISHING_ROD,
        TRIDENT,
        BOW,
        CROSSBOW,
        ARMOR,
        CURSE,
        UNKNOWN;


        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

