/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.tokenenchanter.setup;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;
import net.silentchaos512.tokenenchanter.TokenMod;
import net.silentchaos512.tokenenchanter.crafting.recipe.ApplyEnchantedTokenRecipe;
import net.silentchaos512.tokenenchanter.crafting.recipe.TokenEnchanterRecipe;
import net.silentchaos512.tokenenchanter.crafting.recipe.XpCrystalRecipe;
import net.silentchaos512.tokenenchanter.setup.Registration;

public final class ModRecipes {
    public static final RegistryObject<RecipeType<TokenEnchanterRecipe>> TOKEN_ENCHANTING_TYPE = ModRecipes.registerType("token_enchanting");
    public static final RegistryObject<RecipeSerializer<?>> TOKEN_ENCHANTING = ModRecipes.register("token_enchanting", TokenEnchanterRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPED_XP_CRYSTAL = ModRecipes.register("shaped_xp_crystal", () -> ExtendedShapedRecipe.Serializer.basic(XpCrystalRecipe::new));
    public static final RegistryObject<SimpleCraftingRecipeSerializer<?>> APPLY_ENCHANTED_TOKEN = ModRecipes.register("apply_enchanted_token", () -> new SimpleCraftingRecipeSerializer(ApplyEnchantedTokenRecipe::new));

    private ModRecipes() {
    }

    static void register() {
    }

    private static <T extends RecipeSerializer<?>> RegistryObject<T> register(String name, Supplier<T> serializer) {
        return ModRecipes.register(TokenMod.getId(name), serializer);
    }

    private static <T extends RecipeSerializer<?>> RegistryObject<T> register(ResourceLocation id, Supplier<T> serializer) {
        return Registration.RECIPE_SERIALIZERS.register(id.m_135815_(), serializer);
    }

    private static <T extends Recipe<?>> RegistryObject<RecipeType<T>> registerType(final String name) {
        return Registration.RECIPE_TYPES.register(name, () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        });
    }
}

