/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static void giveItem(Player player, ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        if (!player.m_150109_().m_36054_(copy)) {
            ItemEntity entityItem = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), copy);
            entityItem.m_32061_();
            entityItem.m_32052_(player.m_20148_());
            player.f_19853_.m_7967_((Entity)entityItem);
        }
    }

    public static void removeItem(Player player, ItemStack stack) {
        ImmutableList inventories = ImmutableList.of((Object)player.m_150109_().f_35974_, (Object)player.m_150109_().f_35976_, (Object)player.m_150109_().f_35975_);
        for (NonNullList inv : inventories) {
            for (int i = 0; i < inv.size(); ++i) {
                if (stack != inv.get(i)) continue;
                inv.set(i, (Object)ItemStack.f_41583_);
                return;
            }
        }
    }

    public static CompoundTag getPersistedDataSubcompound(Player player, String subCompoundKey) {
        CompoundTag persistedData;
        CompoundTag forgeData = player.getPersistentData();
        if (!forgeData.m_128441_("PlayerPersisted")) {
            forgeData.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        if (!(persistedData = forgeData.m_128469_("PlayerPersisted")).m_128441_(subCompoundKey)) {
            persistedData.m_128365_(subCompoundKey, (Tag)new CompoundTag());
        }
        return persistedData.m_128469_(subCompoundKey);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player) {
        return PlayerUtils.getNonEmptyStacks(player, true, true, true, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player, Predicate<ItemStack> predicate) {
        return PlayerUtils.getNonEmptyStacks(player, true, true, true, predicate);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player, boolean includeMain, boolean includeOffHand, boolean includeArmor) {
        return PlayerUtils.getNonEmptyStacks(player, includeMain, includeOffHand, includeArmor, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        NonNullList list = NonNullList.m_122779_();
        if (includeMain) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeOffHand) {
            for (ItemStack stack : player.m_150109_().f_35976_) {
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.m_150109_().f_35975_) {
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        return list;
    }

    @Nonnull
    public static ItemStack getFirstValidStack(Player player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        if (includeOffHand) {
            for (ItemStack stack : player.m_150109_().f_35976_) {
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.m_150109_().f_35975_) {
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeMain) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }
}

