/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import net.silentchaos512.lib.util.DimPos;
import net.silentchaos512.lib.util.DimensionId;

public class TeleportUtils {
    public static void teleport(Player player, DimPos pos, @Nullable Direction direction) {
        TeleportUtils.teleport(player, pos.getDimensionId(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, direction);
    }

    public static void teleport(Player player, DimensionId dimension, double destX, double destY, double destZ, @Nullable Direction direction) {
        DimensionId oldId = DimensionId.fromWorld(player.m_20193_());
        float rotationYaw = player.m_146908_();
        float rotationPitch = player.m_146909_();
        if (!oldId.equals(dimension)) {
            TeleportUtils.teleportToDimension(player, dimension, destX, destY, destZ);
        }
        if (direction != null) {
            TeleportUtils.fixOrientation((Entity)player, destX, destY, destZ, direction);
        } else {
            player.m_146922_(rotationYaw);
            player.m_146926_(rotationPitch);
        }
        player.m_6021_(destX, destY, destZ);
    }

    public static void teleportToDimension(Player player, DimensionId dimension, final double x, final double y, final double z) {
        final ServerLevel world = dimension.loadWorld(player.m_20193_());
        player.changeDimension(world, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity.f_19853_ = world;
                world.m_8817_((ServerPlayer)entity);
                entity.m_6027_(x, y, z);
                entity.m_6021_(x, y, z);
                return entity;
            }
        });
    }

    private static void facePosition(Entity entity, double newX, double newY, double newZ, BlockPos dest) {
        double d0 = (double)dest.m_123341_() - newX;
        double d1 = (double)dest.m_123342_() - (newY + (double)entity.m_20192_());
        double d2 = (double)dest.m_123343_() - newZ;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
        entity.m_146926_(TeleportUtils.updateRotation(entity.m_146909_(), f1));
        entity.m_146922_(TeleportUtils.updateRotation(entity.m_146908_(), f));
    }

    private static float updateRotation(float angle, float targetAngle) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        return angle + f;
    }

    public static Entity teleportEntity(Entity entity, DimPos pos, @Nullable Direction facing) {
        return TeleportUtils.teleportEntity(entity, (Level)pos.getDimensionId().getWorld(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, facing);
    }

    public static Entity teleportEntity(Entity entity, Level destWorld, final double newX, final double newY, final double newZ, final @Nullable Direction facing) {
        Level world = entity.m_20193_();
        if (DimensionId.fromWorld(world).equals(DimensionId.fromWorld(destWorld))) {
            if (facing != null) {
                TeleportUtils.fixOrientation(entity, newX, newY, newZ, facing);
            }
            entity.m_7678_(newX, newY, newZ, entity.m_146908_(), entity.m_146909_());
            ((ServerLevel)destWorld).m_8647_(entity);
            return entity;
        }
        return entity.changeDimension((ServerLevel)destWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity = repositionEntity.apply(false);
                if (facing != null) {
                    TeleportUtils.fixOrientation(entity, newX, newY, newZ, facing);
                }
                entity.m_6021_(newX, newY, newZ);
                return entity;
            }
        });
    }

    private static void fixOrientation(Entity entity, double newX, double newY, double newZ, Direction facing) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            TeleportUtils.facePosition(entity, newX, newY, newZ, new BlockPos(new Vec3i((int)newX, (int)newY, (int)newZ)).m_5484_(facing, 4));
        }
    }
}

