/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.Vec3;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_Registry;
import zarkov.utilityworlds.blocks.UW_PortalBlock;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorGarden;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorMining;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorVoid;
import zarkov.utilityworlds.dimensions.UW_DimensionType;

public class UW_Utils {
    public static final Map<String, String> dimensionNameMap = new HashMap<String, String>();

    public static Vec3 getTargetPlayerPos(Vec3 pos, Direction direction) {
        pos = pos.m_82520_(0.5, 0.1, 0.5);
        switch (direction) {
            case NORTH: {
                pos = pos.m_82520_(0.0, 0.0, -1.0);
                break;
            }
            case SOUTH: {
                pos = pos.m_82520_(0.0, 0.0, 1.0);
                break;
            }
            case WEST: {
                pos = pos.m_82520_(-1.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                pos = pos.m_82520_(1.0, 0.0, 0.0);
                break;
            }
            case UP: 
            case DOWN: {
                UW_Log.error("Portal has an invalid direction property.");
            }
        }
        return pos;
    }

    public static String getMappedDimName(String name) {
        if (dimensionNameMap.containsKey(name)) {
            return dimensionNameMap.get(name);
        }
        return name;
    }

    public static BlockPos getDimensionReturnPortalPos(ServerLevel world) {
        ChunkGenerator cl = world.m_7726_().m_8481_();
        if (cl instanceof UW_ChunkGeneratorMining) {
            return UW_DimensionType.miningDimension.returnPortalPos;
        }
        if (cl instanceof UW_ChunkGeneratorVoid) {
            return UW_DimensionType.voidDimension.returnPortalPos;
        }
        if (cl instanceof UW_ChunkGeneratorGarden) {
            return UW_DimensionType.gardenDimension.returnPortalPos;
        }
        UW_Log.error("Unexpected chunk generator type in getDimensionPortalPos");
        return UW_DimensionType.miningDimension.returnPortalPos;
    }

    public static UW_PortalBlock getDimensionPortalBlock(ServerLevel world) {
        ResourceLocation location = world.m_46472_().m_135782_();
        if (location.m_135827_().equals("utilityworlds")) {
            String type;
            String[] segments = location.m_135815_().split("_");
            switch (type = segments[0] + "_" + segments[1]) {
                case "uw_mining": {
                    return UW_Registry.BLOCK_PORTAL_MINING;
                }
                case "uw_void": {
                    return UW_Registry.BLOCK_PORTAL_VOID;
                }
                case "uw_garden": {
                    return UW_Registry.BLOCK_PORTAL_GARDEN;
                }
            }
        }
        UW_Log.error("Attempted to get portal block for invalid dimension.");
        return null;
    }

    public static ResourceKey<Level> getNextDimensionId(Level world, UW_DimensionType type) {
        int maxId = 0;
        for (ServerLevel level : world.m_142572_().m_129785_()) {
            int parsedId;
            ResourceLocation rl = level.m_46472_().m_135782_();
            if (!rl.m_135827_().equals("utilityworlds") || maxId >= (parsedId = UW_Utils.parseDimensionId(rl.m_135815_()).intValue())) continue;
            maxId = parsedId;
        }
        String dimensionName = type.name + "_" + ++maxId;
        UW_Log.info("New dimension ID: " + dimensionName);
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("utilityworlds", dimensionName));
    }

    public static Integer getDimensionId(ResourceKey<Level> dimension) {
        ResourceLocation location = dimension.m_135782_();
        if (!location.m_135827_().equals("utilityworlds")) {
            return null;
        }
        return UW_Utils.parseDimensionId(location.m_135815_());
    }

    private static Integer parseDimensionId(String name) {
        return Integer.parseInt(name.split("_")[2], 10);
    }

    static {
        dimensionNameMap.put("overworld", "Overworld");
    }
}

