/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds;

import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_Registry;
import zarkov.utilityworlds.blocks.UW_PortalBlockEntity;
import zarkov.utilityworlds.blocks.UW_PortalBlockGarden;
import zarkov.utilityworlds.blocks.UW_PortalBlockMining;
import zarkov.utilityworlds.blocks.UW_PortalBlockReturn;
import zarkov.utilityworlds.blocks.UW_PortalBlockVoid;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorGarden;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorMining;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorVoid;
import zarkov.utilityworlds.config.UW_Config;
import zarkov.utilityworlds.config.UW_RecipeConditionGarden;
import zarkov.utilityworlds.config.UW_RecipeConditionPortals;
import zarkov.utilityworlds.network.UW_Messages;
import zarkov.utilityworlds.network.UW_PacketHandler;
import zarkov.utilityworlds.proxy.UW_ClientProxy;
import zarkov.utilityworlds.rendering.UW_PortalBlockEntityRenderer;

@Mod(value="utilityworlds")
public class UtilityWorlds {
    public static final String MODID = "utilityworlds";
    public static SimpleChannel channel = UW_PacketHandler.INSTANCE;

    public UtilityWorlds() {
        UW_Config.register();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventListeners {
        private static final PortalsTab creativeTab = new PortalsTab(CreativeModeTab.getGroupCountSafe(), "portal_blocks");

        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            UW_Log.trace("FMLCommonSetupEvent");
            int discriminator = 0;
            channel.registerMessage(discriminator++, UW_Messages.MsgLinkGUI.class, UW_Messages.MsgLinkGUI::encode, UW_Messages.MsgLinkGUI::new, UW_Messages.MsgLinkGUI::handle);
            channel.registerMessage(discriminator++, UW_Messages.MsgLinkToDim.class, UW_Messages.MsgLinkToDim::encode, UW_Messages.MsgLinkToDim::new, UW_Messages.MsgLinkToDim::handle);
            CraftingHelper.register(UW_RecipeConditionGarden.SERIALIZER);
            CraftingHelper.register(UW_RecipeConditionPortals.SERIALIZER);
            event.enqueueWork(() -> {
                Registry.m_122961_((Registry)Registry.f_122890_, (String)"mining_cg", UW_ChunkGeneratorMining.CODEC);
                Registry.m_122961_((Registry)Registry.f_122890_, (String)"void_cg", UW_ChunkGeneratorVoid.CODEC);
                Registry.m_122961_((Registry)Registry.f_122890_, (String)"garden_cg", UW_ChunkGeneratorGarden.CODEC);
            });
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            UW_Log.trace("FMLClientSetupEvent");
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UW_ClientProxy.registerDimensionEffects());
            MinecraftForge.EVENT_BUS.addListener(ForgeEventListeners::onFogColors);
        }

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            event.getRegistry().register((IForgeRegistryEntry)new UW_PortalBlockMining());
            event.getRegistry().register((IForgeRegistryEntry)new UW_PortalBlockVoid());
            event.getRegistry().register((IForgeRegistryEntry)new UW_PortalBlockGarden());
            event.getRegistry().register((IForgeRegistryEntry)new UW_PortalBlockReturn());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            UW_Log.trace("RegistryEvent.Register<Item>");
            Item.Properties properties = new Item.Properties().m_41491_((CreativeModeTab)creativeTab);
            event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_MINING, properties).setRegistryName(UW_Registry.BLOCK_PORTAL_MINING.getRegistryName())));
            event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_VOID, properties).setRegistryName(UW_Registry.BLOCK_PORTAL_VOID.getRegistryName())));
            event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_GARDEN, properties).setRegistryName(UW_Registry.BLOCK_PORTAL_GARDEN.getRegistryName())));
            event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_RETURN, new Item.Properties()).setRegistryName(UW_Registry.BLOCK_PORTAL_RETURN.getRegistryName())));
        }

        @SubscribeEvent
        public static void onBlockEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> event) {
            UW_Log.trace("RegistryEvent.Register<BlockEntityType<?>>");
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(UW_PortalBlockEntity::new, (Block[])new Block[]{UW_Registry.BLOCK_PORTAL_MINING, UW_Registry.BLOCK_PORTAL_VOID, UW_Registry.BLOCK_PORTAL_GARDEN, UW_Registry.BLOCK_PORTAL_RETURN}).m_58966_(null).setRegistryName("portal_block_entity")));
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            UW_Log.trace("EntityRenderersEvent.RegisterRenderers");
            event.registerBlockEntityRenderer(UW_Registry.PORTAL_BLOCK_ENTITY, UW_PortalBlockEntityRenderer::new);
        }

        private static class PortalsTab
        extends CreativeModeTab {
            public PortalsTab(int index, String name) {
                super(index, name);
            }

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)UW_Registry.BLOCK_PORTAL_MINING);
            }
        }
    }

    public static class ForgeEventListeners {
        @OnlyIn(value=Dist.CLIENT)
        public static void onFogColors(EntityViewRenderEvent.FogColors event) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UW_ClientProxy.onFogColors(event));
        }
    }
}

