/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.blocks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.network.PacketDistributor;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_Registry;
import zarkov.utilityworlds.UW_Utils;
import zarkov.utilityworlds.UtilityWorlds;
import zarkov.utilityworlds.blocks.UW_PortalBlockEntity;
import zarkov.utilityworlds.blocks.UW_PortalBlockReturn;
import zarkov.utilityworlds.dimensions.UW_DimensionManager;
import zarkov.utilityworlds.dimensions.UW_DimensionType;
import zarkov.utilityworlds.network.UW_Messages;

public abstract class UW_PortalBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final AABB boundaryBox = new AABB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    protected UW_PortalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60913_(0.25f, 3600000.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> 0));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new UW_PortalBlockEntity(pos, state);
    }

    abstract UW_DimensionType getDimensionType();

    public VoxelShape m_5940_(BlockState p_50952_, BlockGetter p_50953_, BlockPos p_50954_, CollisionContext p_50955_) {
        return Shapes.m_83064_((AABB)boundaryBox);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return false;
    }

    public static void createReturnPortal(ServerLevel srcWorld, UW_PortalBlockEntity srcPortal, ServerLevel dstWorld, BlockPos returnPortalPos) {
        if (null == returnPortalPos) {
            returnPortalPos = UW_Utils.getDimensionReturnPortalPos(dstWorld);
        }
        dstWorld.m_46961_(returnPortalPos.m_142127_(), true);
        dstWorld.m_46961_(returnPortalPos.m_142127_().m_7494_(), true);
        dstWorld.m_46961_(returnPortalPos.m_142127_().m_7494_().m_7494_(), true);
        BlockState slabs = (BlockState)Blocks.f_50405_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
        dstWorld.m_7731_(returnPortalPos.m_142127_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos.m_142128_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos.m_142126_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos.m_142125_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos, (BlockState)UW_Registry.BLOCK_PORTAL_RETURN.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH), 3);
        BlockEntity te = dstWorld.m_7702_(returnPortalPos);
        if (null != te && te instanceof UW_PortalBlockEntity) {
            UW_PortalBlockEntity returnPortal = (UW_PortalBlockEntity)te;
            srcPortal.remoteDimensionId = dstWorld.m_46472_();
            srcPortal.remotePos = returnPortalPos;
            srcPortal.remoteDir = (byte)Direction.NORTH.ordinal();
            srcPortal.m_6596_();
            returnPortal.remoteDimensionId = srcPortal.localDimensionId;
            returnPortal.remotePos = new BlockPos((Vec3i)srcPortal.localPos);
            returnPortal.remoteDir = srcPortal.localDir;
            returnPortal.localDimensionId = srcPortal.remoteDimensionId;
            returnPortal.localPos = returnPortalPos;
            returnPortal.localDir = (byte)Direction.NORTH.ordinal();
            returnPortal.isReturnPortal = true;
            returnPortal.m_142339_((Level)dstWorld);
            returnPortal.m_6596_();
        } else {
            UW_Log.error("No return portal block entity found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rt) {
        if (!world.f_46443_) {
            BlockEntity be = world.m_7702_(pos);
            if (null != be && be instanceof UW_PortalBlockEntity && null != player) {
                UW_PortalBlockEntity portal = (UW_PortalBlockEntity)be;
                if (null == portal.localDimensionId) {
                    UW_Log.error("Portal tile entity invalid, localDimensionId is null.");
                    return InteractionResult.PASS;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (serverPlayer.m_6047_() && null == portal.remoteDimensionId && serverPlayer.m_7500_()) {
                        ArrayList<String> dimNames = new ArrayList<String>();
                        ArrayList<BlockPos> portalPos = new ArrayList<BlockPos>();
                        Iterable levels = world.m_142572_().m_129785_();
                        for (Level level : levels) {
                            Integer dimensionId;
                            if (level.m_46472_() == portal.localDimensionId || null == (dimensionId = UW_Utils.getDimensionId((ResourceKey<Level>)level.m_46472_())) && !UW_Utils.dimensionNameMap.containsKey(level.m_46472_().m_135782_().m_135815_())) continue;
                            dimNames.add(level.m_46472_().m_135782_().toString());
                            if (null != dimensionId) {
                                portalPos.add(UW_Utils.getDimensionReturnPortalPos((ServerLevel)level));
                                continue;
                            }
                            portalPos.add(new BlockPos(0, 0, 0));
                        }
                        UtilityWorlds.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new UW_Messages.MsgLinkGUI(dimNames.size(), portal.localDimensionId.m_135782_().toString(), portal.localPos, portal.localDir, dimNames, portalPos));
                        return InteractionResult.SUCCESS;
                    }
                    ServerLevel remoteDimension = null;
                    if (null == portal.remoteDimensionId && !(this instanceof UW_PortalBlockReturn)) {
                        UW_DimensionType type = this.getDimensionType();
                        ResourceKey<Level> dimensionKey = null;
                        Class<UtilityWorlds> clazz = UtilityWorlds.class;
                        synchronized (UtilityWorlds.class) {
                            dimensionKey = UW_Utils.getNextDimensionId(world, type);
                            // ** MonitorExit[var13_17] (shouldn't be in output)
                            try {
                                remoteDimension = UW_DimensionManager.createDimension(type, ((ServerLevel)world).m_142572_(), dimensionKey);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                                UW_Log.error("Exception creating dimension:", e);
                                return InteractionResult.SUCCESS;
                            }
                            ServerLevel localDimension = world.m_142572_().m_129880_(world.m_46472_());
                            if (null != localDimension && null != remoteDimension) {
                                UW_PortalBlock.createReturnPortal(localDimension, portal, remoteDimension, null);
                            }
                        }
                    } else if (null != portal.remoteDimensionId) {
                        remoteDimension = world.m_142572_().m_129880_(portal.remoteDimensionId);
                    }
                    {
                        if (null != remoteDimension) {
                            remoteDimension.m_8606_(Integer.MAX_VALUE, 0, false, false);
                            ServerLevel finalRemoteDimension = remoteDimension;
                            serverPlayer.m_20194_().m_6937_((Runnable)new TickTask(serverPlayer.m_20194_().m_129921_(), () -> {
                                UW_Log.info("Teleporting player '" + serverPlayer.m_5446_().getString() + "' to dimension: " + finalRemoteDimension.m_46472_().m_135782_().m_135815_());
                                Direction direction = Direction.values()[portal.remoteDir];
                                Vec3 position = UW_Utils.getTargetPlayerPos(new Vec3((double)portal.remotePos.m_123341_(), (double)portal.remotePos.m_123342_(), (double)portal.remotePos.m_123343_()), direction);
                                serverPlayer.m_6330_(UW_Registry.PORTAL_SOUND, SoundSource.BLOCKS, 1.0f, 1.0f);
                                finalRemoteDimension.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(portal.remotePos), 1, (Object)serverPlayer.m_142049_());
                                serverPlayer.m_8999_(finalRemoteDimension, position.f_82479_, position.f_82480_, position.f_82481_, Direction.values()[portal.remoteDir].m_122435_(), 0.0f);
                                serverPlayer.m_6330_(UW_Registry.PORTAL_SOUND, SoundSource.BLOCKS, 1.0f, 1.0f);
                                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetHealthPacket(serverPlayer.m_21223_(), serverPlayer.m_36324_().m_38702_(), serverPlayer.m_36324_().m_38722_()));
                                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetExperiencePacket(serverPlayer.f_36080_, serverPlayer.f_36079_, serverPlayer.f_36078_));
                                for (MobEffectInstance mobEffect : serverPlayer.m_21220_()) {
                                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_142049_(), mobEffect));
                                }
                            }));
                        } else {
                            UW_Log.error("use: remoteDimension is null!");
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                UW_Log.error("use: Unexpected values: be = " + be + ", player = " + player);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack itemStack) {
        Direction direction = null;
        if (entity != null) {
            direction = Direction.m_122364_((double)entity.f_19859_).m_122424_();
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction), 3);
        }
        if (!world.f_46443_) {
            ServerLevel localDimension = (ServerLevel)world;
            UW_PortalBlockEntity portal = (UW_PortalBlockEntity)localDimension.m_7702_(pos);
            if (null != portal) {
                ResourceKey localDimensionId = localDimension.m_46472_();
                boolean invalid_location = false;
                ArrayList<TextComponent> components = new ArrayList<TextComponent>();
                if (null != portal.isReturnPortal && portal.isReturnPortal.booleanValue() && localDimensionId != portal.localDimensionId) {
                    invalid_location = true;
                    String dimensionName = portal.localDimensionId.m_135782_().m_135815_();
                    components.add(new TextComponent(ChatFormatting.RED + "This portal can only be placed in dimension " + dimensionName + "." + ChatFormatting.RESET));
                }
                if (portal.remoteDimensionId != null && portal.remoteDimensionId == localDimensionId) {
                    invalid_location = true;
                    components.add(new TextComponent(ChatFormatting.RED + "A portal cannot be placed in the target dimension." + ChatFormatting.RESET));
                }
                if (invalid_location) {
                    itemStack.m_41764_(0);
                    List drops = Block.m_49869_((BlockState)portal.m_58900_(), (ServerLevel)localDimension, (BlockPos)pos, (BlockEntity)portal);
                    localDimension.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.m_36176_((ItemStack)drops.get(0), true);
                        for (TextComponent component : components) {
                            player.m_6352_((Component)component, Util.f_137441_);
                        }
                    }
                    return;
                }
                portal.localDimensionId = localDimension.m_46472_();
                portal.localPos = new BlockPos((Vec3i)pos);
                portal.localDir = (byte)direction.ordinal();
                portal.m_142339_((Level)localDimension);
                portal.m_6596_();
                if (null != portal.remoteDimensionId) {
                    ServerLevel remoteDimension = localDimension.m_142572_().m_129880_(portal.remoteDimensionId);
                    boolean remoteUpdated = false;
                    UW_PortalBlockEntity remotePortal = null;
                    if (null != remoteDimension && null != (remotePortal = (UW_PortalBlockEntity)remoteDimension.m_7702_(portal.remotePos))) {
                        remotePortal.remoteDimensionId = localDimension.m_46472_();
                        remotePortal.remotePos = new BlockPos((Vec3i)portal.localPos);
                        remotePortal.remoteDir = portal.localDir;
                        remotePortal.m_6596_();
                        remoteUpdated = true;
                    }
                    if (!remoteUpdated) {
                        UW_Log.error("Failed to update remote portal. remoteWorld = " + (Level)remoteDimension + ", remotePortal = " + remotePortal + ".");
                    }
                }
            } else {
                UW_Log.error("setPlacedBy: Portal block entity is null!");
            }
        }
    }
}

