/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import zarkov.utilityworlds.chunkgen.UW_ChunkGenerator;
import zarkov.utilityworlds.config.UW_Config;

public class UW_ChunkGeneratorMining
extends UW_ChunkGenerator {
    protected final Registry<Biome> biomeRegistry;
    private final Biome biome;
    static final int floorLevel = (Integer)UW_Config.MINING_DIMENSION_FLOOR.get();
    public static final Codec<UW_ChunkGeneratorMining> CODEC = RecordCodecBuilder.create(p_208215_ -> UW_ChunkGeneratorMining.m_208005_((RecordCodecBuilder.Instance)p_208215_).and((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(p_208210_ -> p_208210_.biomeRegistry)).apply((Applicative)p_208215_, p_208215_.stable(UW_ChunkGeneratorMining::new)));
    private final WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));
    private final WorldgenRandom worldgenSlateRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));

    public UW_ChunkGeneratorMining(Registry<StructureSet> structureRegistry, Registry<Biome> biomeRegistry) {
        super(structureRegistry, Optional.empty(), (BiomeSource)new FixedBiomeSource(biomeRegistry.m_203538_(Biomes.f_186765_)));
        this.biomeRegistry = biomeRegistry;
        this.biome = (Biome)biomeRegistry.m_6246_(Biomes.f_186765_);
    }

    public Registry<Biome> biomeRegistry() {
        return this.biomeRegistry;
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager sfManager, ChunkAccess chunk) {
        Heightmap oceanHeightmap = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap surfaceHeightmap = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, floorLevel, z), this.bedrock, false);
                for (y = floorLevel + 1; y < 10; ++y) {
                    chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, y, z), this.slateGradient(y, 0, 8) ? this.deepslate : this.stone, false);
                }
                for (y = 10; y < 61; ++y) {
                    chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, y, z), this.stone, false);
                }
                for (y = 61; y < 63; ++y) {
                    chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, y, z), this.dirt, false);
                }
                chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, 63, z), this.grass, false);
                oceanHeightmap.m_64249_(x, 63, z, this.grass);
                surfaceHeightmap.m_64249_(x, 63, z, this.grass);
            }
        }
    }

    public void m_183372_(WorldGenLevel level, ChunkAccess chunk, StructureFeatureManager sfManager) {
        ChunkPos chunkpos = chunk.m_7697_();
        SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)chunk.m_151560_());
        BlockPos blockpos = sectionpos.m_123249_();
        long seed = this.worldgenRandom.m_64690_(level.m_7328_(), blockpos.m_123341_(), blockpos.m_123343_());
        int featureIndex = 0;
        int featureSetIndex = 0;
        Registry registry = level.m_5962_().m_175515_(Registry.f_194567_);
        for (HolderSet featureHolderSet : this.biome.m_47536_().m_47818_()) {
            for (Holder featureHolder : featureHolderSet) {
                PlacedFeature placedFeature = (PlacedFeature)featureHolder.m_203334_();
                this.worldgenRandom.m_190064_(seed, ++featureIndex, featureSetIndex);
                Supplier<String> genSupplier = () -> registry.m_7854_((Object)placedFeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedFeature).toString());
                boolean place = true;
                Iterator iterator = ((ConfiguredFeature)placedFeature.f_191775_().m_203334_()).m_65398_().iterator();
                while (iterator.hasNext()) {
                    ConfiguredFeature next = (ConfiguredFeature)iterator.next();
                    if (!next.f_65377_().getRegistryName().m_135815_().equals("lake")) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                level.m_183406_(genSupplier);
                Stream<Object> stream = Stream.of(blockpos);
                PlacementContext context = new PlacementContext(level, (ChunkGenerator)this, Optional.of(placedFeature));
                for (PlacementModifier placementModifier : placedFeature.f_191776_()) {
                    if (placementModifier.m_183327_() == BiomeFilter.m_191561_().m_183327_()) continue;
                    stream = stream.flatMap(blockPos -> placementModifier.m_183381_(context, (Random)this.worldgenRandom, blockPos));
                }
                ConfiguredFeature configuredFeature = (ConfiguredFeature)placedFeature.f_191775_().m_203334_();
                stream.forEach(blockPos -> configuredFeature.m_65385_(context.m_191831_(), context.m_191833_(), (Random)this.worldgenRandom, blockPos));
            }
            ++featureSetIndex;
        }
        level.m_183406_(null);
    }

    private boolean slateGradient(int y, int lower, int upper) {
        int k = y;
        if ((Integer)UW_Config.MINING_DIMENSION_FLOOR.get() == 0) {
            return false;
        }
        if (k <= lower) {
            return true;
        }
        if (k >= upper) {
            return false;
        }
        double d0 = Mth.m_144914_((double)k, (double)lower, (double)upper, (double)1.0, (double)0.0);
        return this.worldgenSlateRandom.nextDouble() < d0;
    }

    @Override
    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager sfManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public int m_6331_() {
        return 128;
    }

    @Override
    public int m_142647_(int p_156153_, int p_156154_, Heightmap.Types p_156155_, LevelHeightAccessor p_156156_) {
        return this.m_6337_();
    }

    @Override
    public NoiseColumn m_141914_(int p_156150_, int p_156151_, LevelHeightAccessor p_156152_) {
        Object[] states = new BlockState[128];
        Arrays.fill(states, this.stone);
        states[0] = this.bedrock;
        return new NoiseColumn(-63, new BlockState[0]);
    }

    public int m_6337_() {
        return 63;
    }

    @Override
    public int m_142062_() {
        return floorLevel;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }
}

