/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.config;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class UW_Config {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_CLIENT = "client";
    public static ForgeConfigSpec.BooleanValue ALLOW_PORTAL_CRAFTING;
    public static ForgeConfigSpec.BooleanValue ALLOW_GARDEN_WORLD;
    public static ForgeConfigSpec.BooleanValue DARK_VOID_WORLD;
    public static ForgeConfigSpec.ConfigValue<Integer> MINING_DIMENSION_FLOOR;

    public static void register() {
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER.comment("Client settings").push(CATEGORY_CLIENT);
        DARK_VOID_WORLD = CLIENT_BUILDER.comment(" Set to true for an End dimension background in Void World.").define("darkVoidWorld", false);
        CLIENT_BUILDER.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_BUILDER.build());
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        ALLOW_PORTAL_CRAFTING = COMMON_BUILDER.comment(" Set to true to allow portal blocks to be crafted by players.").define("allowPortalCrafting", true);
        ALLOW_GARDEN_WORLD = COMMON_BUILDER.comment(" Set to true to enable the Garden World recipe.").define("enableGardenWorld", true);
        ArrayList<Integer> floorValues = new ArrayList<Integer>();
        floorValues.add(-64);
        floorValues.add(0);
        MINING_DIMENSION_FLOOR = COMMON_BUILDER.comment(" Lowest y-level in the Mining World (can be -64 or 0, default is -64).").defineInList("miningDimensionFloor", (Object)-64, floorValues);
        COMMON_BUILDER.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_BUILDER.build());
    }
}

