/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.dimensions;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.chunkgen.UW_ChunkGenerator;
import zarkov.utilityworlds.dimensions.UW_DimensionType;

public class UW_DimensionManager {
    public static ServerLevel createDimension(UW_DimensionType dimensionType, MinecraftServer server, ResourceKey<Level> dimensionKey) throws SecurityException, NoSuchFieldException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Map map = server.forgeGetWorldMap();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)dimensionKey.m_135782_());
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        Holder typeHolder = registryAccess.m_175515_(Registry.f_122818_).m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("utilityworlds", dimensionType.name)));
        UW_ChunkGenerator chunkGenerator = dimensionType.chunkGenerator.getConstructor(Registry.class, Registry.class).newInstance(registryAccess.m_175515_(Registry.f_211073_), registryAccess.m_175515_(Registry.f_122885_));
        LevelStem dimension = new LevelStem(typeHolder, (ChunkGenerator)chunkGenerator, true);
        ChunkProgressListener chunkProgressListener = server.f_129756_.m_9620_(11);
        Executor executor = server.f_129738_;
        LevelStorageSource.LevelStorageAccess anvilConverter = server.f_129744_;
        WorldData worldData = server.m_129910_();
        WorldGenSettings registryHolder = worldData.m_5961_();
        WorldGenSettings worldGenSettings = new WorldGenSettings(worldData.m_5961_().m_64619_(), false, false, registryHolder.f_64605_, Optional.of(""));
        Registry dimensionRegistry = worldGenSettings.m_204655_();
        if (!(dimensionRegistry instanceof WritableRegistry)) {
            throw new IllegalStateException("Unable to register dimension '" + dimensionKey.m_135782_() + "'! Registry not writable!");
        }
        WritableRegistry writableRegistry = (WritableRegistry)dimensionRegistry;
        writableRegistry.m_203505_(worldKey, (Object)dimension, Lifecycle.stable());
        LevelSettings levelSettings = new LevelSettings(worldData.m_5462_(), worldData.m_5464_(), worldData.m_5466_(), worldData.m_5472_(), worldData.m_5468_(), worldData.m_5470_(), DataPackConfig.f_45842_, Lifecycle.stable());
        PrimaryLevelData levelData = new PrimaryLevelData(levelSettings, worldGenSettings, Lifecycle.stable());
        levelData.m_6393_(Integer.MAX_VALUE);
        ServerLevel level = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)levelData, dimensionKey, typeHolder, chunkProgressListener, dimension.m_63990_(), worldGenSettings.m_64668_(), BiomeManager.m_47877_((long)worldGenSettings.m_64619_()), Collections.emptyList(), true);
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(level.m_6857_()));
        map.put(dimensionKey, level);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((LevelAccessor)level));
        UW_Log.info("Created new dimension with ID " + dimensionKey.toString());
        return level;
    }
}

