/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import zarkov.utilityworlds.UW_Registry;
import zarkov.utilityworlds.UW_Utils;
import zarkov.utilityworlds.blocks.UW_PortalBlock;
import zarkov.utilityworlds.blocks.UW_PortalBlockEntity;
import zarkov.utilityworlds.proxy.UW_ClientProxy;

public class UW_Messages {

    public static class MsgLinkToDim {
        private String srcDimensionId;
        private BlockPos srcPortalPos;
        private byte srcPortalDir;
        private String dstDimensionId;
        private BlockPos dstPortalPos;

        public MsgLinkToDim(FriendlyByteBuf buffer) {
            this.srcDimensionId = buffer.m_130277_();
            this.srcPortalPos = buffer.m_130135_();
            this.srcPortalDir = buffer.readByte();
            this.dstDimensionId = buffer.m_130277_();
            this.dstPortalPos = buffer.m_130135_();
        }

        public MsgLinkToDim(String srcDimensionId, BlockPos srcPortalPos, byte srcPortalDir, String dstDimensionId, BlockPos dstPortalPos) {
            this.srcDimensionId = srcDimensionId;
            this.srcPortalPos = srcPortalPos;
            this.srcPortalDir = srcPortalDir;
            this.dstDimensionId = dstDimensionId;
            this.dstPortalPos = dstPortalPos;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.srcDimensionId);
            buffer.m_130064_(this.srcPortalPos);
            buffer.writeByte((int)this.srcPortalDir);
            buffer.m_130070_(this.dstDimensionId);
            buffer.m_130064_(this.dstPortalPos);
        }

        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
                sender.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.srcDimensionId)));
                ServerLevel srcWorld = sender.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.srcDimensionId)));
                ServerLevel dstWorld = sender.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.dstDimensionId)));
                BlockEntity srcTE = srcWorld.m_7702_(this.srcPortalPos);
                if (null != srcTE && null != srcWorld && null != dstWorld) {
                    UW_PortalBlockEntity srcPortal = (UW_PortalBlockEntity)srcTE;
                    srcPortal.remoteDimensionId = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.dstDimensionId));
                    srcPortal.remotePos = this.dstPortalPos;
                    srcPortal.remoteDir = (byte)Direction.NORTH.ordinal();
                    UW_PortalBlock.createReturnPortal(srcWorld, srcPortal, dstWorld, this.dstPortalPos);
                    srcPortal = (UW_PortalBlockEntity)srcWorld.m_7702_(this.srcPortalPos);
                    if (dstWorld.m_46472_().m_135782_().m_135827_().equals("utilityworlds")) {
                        srcWorld.m_46597_(this.srcPortalPos, (BlockState)UW_Utils.getDimensionPortalBlock(dstWorld).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.values()[this.srcPortalDir]));
                        srcWorld.m_151523_((BlockEntity)srcPortal);
                    } else if (srcWorld.m_46472_().m_135782_().m_135827_().equals("utilityworlds")) {
                        srcWorld.m_46597_(this.srcPortalPos, (BlockState)UW_Registry.BLOCK_PORTAL_RETURN.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.values()[this.srcPortalDir]));
                        srcWorld.m_151523_((BlockEntity)srcPortal);
                        UW_PortalBlockEntity dstPortal = (UW_PortalBlockEntity)dstWorld.m_7702_(this.dstPortalPos);
                        dstWorld.m_46597_(this.dstPortalPos, (BlockState)UW_Utils.getDimensionPortalBlock(srcWorld).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.values()[srcPortal.remoteDir]));
                        dstWorld.m_151523_((BlockEntity)dstPortal);
                        dstPortal.m_6596_();
                    }
                    srcPortal.m_6596_();
                    sender.m_6352_((Component)new TextComponent("Return portal created."), sender.m_142081_());
                } else {
                    sender.m_6352_((Component)new TextComponent("Failed to create return portal."), sender.m_142081_());
                }
            });
            context.get().setPacketHandled(true);
        }
    }

    public static class MsgLinkGUI {
        private int dimensionCount;
        private String localDimensionId;
        private BlockPos localPortalPos;
        private byte localPortalDir;
        private List<String> listDimensions;
        private List<BlockPos> listPortalPos;

        public MsgLinkGUI(FriendlyByteBuf buffer) {
            int i;
            this.dimensionCount = buffer.readInt();
            this.localDimensionId = buffer.m_130277_();
            this.localPortalPos = buffer.m_130135_();
            this.localPortalDir = buffer.readByte();
            this.listDimensions = new ArrayList<String>();
            this.listPortalPos = new ArrayList<BlockPos>();
            for (i = 0; i < this.dimensionCount; ++i) {
                this.listDimensions.add(buffer.m_130277_());
            }
            for (i = 0; i < this.dimensionCount; ++i) {
                this.listPortalPos.add(buffer.m_130135_());
            }
        }

        public MsgLinkGUI(int dimensionCount, String localDimensionId, BlockPos localPortalPos, byte localPortalDir, List<String> dimensions, List<BlockPos> listPortalPos) {
            this.dimensionCount = dimensionCount;
            this.localDimensionId = localDimensionId;
            this.localPortalPos = localPortalPos;
            this.localPortalDir = localPortalDir;
            this.listDimensions = new ArrayList<String>(dimensions);
            this.listPortalPos = new ArrayList<BlockPos>(listPortalPos);
        }

        public static void encode(MsgLinkGUI msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.dimensionCount);
            buffer.m_130070_(msg.localDimensionId);
            buffer.m_130064_(msg.localPortalPos);
            buffer.writeByte((int)msg.localPortalDir);
            for (String name : msg.listDimensions) {
                buffer.m_130070_(name);
            }
            for (BlockPos pos : msg.listPortalPos) {
                buffer.m_130064_(pos);
            }
        }

        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UW_ClientProxy.showOverrideGUI(this.localDimensionId, this.localPortalPos, this.localPortalDir, this.listDimensions, this.listPortalPos)));
            context.get().setPacketHandled(true);
        }
    }
}

