/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_Registry;
import zarkov.utilityworlds.blocks.UW_PortalBlockEntity;
import zarkov.utilityworlds.blocks.UW_PortalBlockGarden;
import zarkov.utilityworlds.blocks.UW_PortalBlockMining;
import zarkov.utilityworlds.blocks.UW_PortalBlockReturn;
import zarkov.utilityworlds.blocks.UW_PortalBlockVoid;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorGarden;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorMining;
import zarkov.utilityworlds.chunkgen.UW_ChunkGeneratorVoid;
import zarkov.utilityworlds.config.UW_Config;
import zarkov.utilityworlds.config.UW_RecipeConditionGarden;
import zarkov.utilityworlds.config.UW_RecipeConditionPortals;
import zarkov.utilityworlds.network.UW_Messages;
import zarkov.utilityworlds.network.UW_PacketHandler;
import zarkov.utilityworlds.rendering.UW_DimensionEffects;
import zarkov.utilityworlds.rendering.UW_PortalBlockEntityRenderer;

@Mod(value="utilityworlds")
public class UtilityWorlds {
    public static final String MODID = "utilityworlds";
    public static SimpleChannel channel = UW_PacketHandler.INSTANCE;

    public UtilityWorlds() {
        UW_Config.register();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventListeners {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            UW_Log.trace("FMLCommonSetupEvent");
            int discriminator = 0;
            channel.registerMessage(discriminator++, UW_Messages.MsgLinkGUI.class, UW_Messages.MsgLinkGUI::encode, UW_Messages.MsgLinkGUI::new, UW_Messages.MsgLinkGUI::handle);
            channel.registerMessage(discriminator++, UW_Messages.MsgLinkToDim.class, UW_Messages.MsgLinkToDim::encode, UW_Messages.MsgLinkToDim::new, UW_Messages.MsgLinkToDim::handle);
            CraftingHelper.register(UW_RecipeConditionGarden.SERIALIZER);
            CraftingHelper.register(UW_RecipeConditionPortals.SERIALIZER);
            event.enqueueWork(() -> {
                Registry.m_122961_((Registry)BuiltInRegistries.f_256914_, (String)"mining_cg", UW_ChunkGeneratorMining.CODEC);
                Registry.m_122961_((Registry)BuiltInRegistries.f_256914_, (String)"void_cg", UW_ChunkGeneratorVoid.CODEC);
                Registry.m_122961_((Registry)BuiltInRegistries.f_256914_, (String)"garden_cg", UW_ChunkGeneratorGarden.CODEC);
            });
        }

        @SubscribeEvent
        public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
            UW_Log.trace("RegisterDimensionSpecialEffectsEvent received");
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UW_DimensionEffects.registerDimensionEffects(event));
        }

        @SubscribeEvent
        public static void onCreativeTabRegistry(CreativeModeTabEvent.Register event) {
            event.registerCreativeModeTab(new ResourceLocation(UtilityWorlds.MODID, "portal_blocks"), builder -> builder.m_257941_((Component)Component.m_237115_((String)"item_group.portal_blocks")).m_257737_(() -> new ItemStack((ItemLike)UW_Registry.BLOCK_PORTAL_MINING)).m_257501_((itemDisplayParameters, output) -> {
                output.m_246326_((ItemLike)UW_Registry.BLOCK_PORTAL_MINING);
                output.m_246326_((ItemLike)UW_Registry.BLOCK_PORTAL_VOID);
                output.m_246326_((ItemLike)UW_Registry.BLOCK_PORTAL_GARDEN);
            }));
        }

        @SubscribeEvent
        public static void onRegistry(RegisterEvent event) {
            IForgeRegistry registry;
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
                UW_Log.trace("RegisterEvent: ForgeRegistries.Keys.BLOCKS");
                registry = event.getForgeRegistry();
                if (registry != null) {
                    registry.register("portal_mining", (Object)new UW_PortalBlockMining());
                    registry.register("portal_void", (Object)new UW_PortalBlockVoid());
                    registry.register("portal_garden", (Object)new UW_PortalBlockGarden());
                    registry.register("portal_return", (Object)new UW_PortalBlockReturn());
                }
            }
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                UW_Log.trace("RegisterEvent: ForgeRegistries.Keys.ITEMS");
                Item.Properties properties = new Item.Properties();
                IForgeRegistry registry2 = event.getForgeRegistry();
                if (registry2 != null) {
                    registry2.register("utilityworlds:portal_mining", (Object)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_MINING, properties));
                    registry2.register("portal_void", (Object)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_VOID, properties));
                    registry2.register("portal_garden", (Object)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_GARDEN, properties));
                    registry2.register("portal_return", (Object)new BlockItem((Block)UW_Registry.BLOCK_PORTAL_RETURN, new Item.Properties()));
                }
            }
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCK_ENTITY_TYPES)) {
                UW_Log.trace("RegisterEvent: ForgeRegistries.Keys.BLOCK_ENTITY_TYPES");
                registry = event.getForgeRegistry();
                if (registry != null) {
                    registry.register("portal_block_entity", (Object)BlockEntityType.Builder.m_155273_(UW_PortalBlockEntity::new, (Block[])new Block[]{UW_Registry.BLOCK_PORTAL_MINING, UW_Registry.BLOCK_PORTAL_VOID, UW_Registry.BLOCK_PORTAL_GARDEN, UW_Registry.BLOCK_PORTAL_RETURN}).m_58966_(null));
                }
            }
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            UW_Log.trace("EntityRenderersEvent.RegisterRenderers");
            event.registerBlockEntityRenderer(UW_Registry.PORTAL_BLOCK_ENTITY, UW_PortalBlockEntityRenderer::new);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventListeners {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onComputeFogColorEvent(ViewportEvent.ComputeFogColor event) {
            if (event.getCamera().m_90592_().f_19853_.m_46472_().m_135782_().m_135827_().equals(UtilityWorlds.MODID)) {
                event.setRed(0.46875f);
                event.setGreen(0.65234375f);
                event.setBlue(1.0f);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onLivingFallEvent(LivingFallEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.f_19797_ < 50 && entity instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)entity;
                if (player.f_19853_.m_46472_().m_135782_().m_135827_().equals(UtilityWorlds.MODID) && player.f_19789_ < 25.0f) {
                    UW_Log.debug("Unexpected fall damage sound prevented (" + player.f_19797_ + " ticks, " + event.getDistance() + " fall distance)");
                    event.setCanceled(true);
                }
            }
        }
    }
}

