/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.blocks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.PacketDistributor;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_Registry;
import zarkov.utilityworlds.UW_Utils;
import zarkov.utilityworlds.UtilityWorlds;
import zarkov.utilityworlds.blocks.UW_PortalBlockEntity;
import zarkov.utilityworlds.blocks.UW_PortalBlockReturn;
import zarkov.utilityworlds.dimensions.UW_DimensionManager;
import zarkov.utilityworlds.dimensions.UW_DimensionType;
import zarkov.utilityworlds.dimensions.UW_Teleporter;
import zarkov.utilityworlds.network.UW_Messages;

public abstract class UW_PortalBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final AABB boundaryBox = new AABB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    protected UW_PortalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60913_(0.25f, 3600000.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> 0));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new UW_PortalBlockEntity(pos, state);
    }

    abstract UW_DimensionType getDimensionType();

    @Deprecated
    public VoxelShape m_5940_(BlockState p_50952_, BlockGetter p_50953_, BlockPos p_50954_, CollisionContext p_50955_) {
        return Shapes.m_83064_((AABB)boundaryBox);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return false;
    }

    public static void createReturnPortal(ServerLevel srcWorld, UW_PortalBlockEntity srcPortal, ServerLevel dstWorld, BlockPos returnPortalPos) {
        if (null == returnPortalPos) {
            returnPortalPos = UW_Utils.getDimensionReturnPortalPos(dstWorld);
        }
        dstWorld.m_46961_(returnPortalPos.m_122012_(), true);
        dstWorld.m_46961_(returnPortalPos.m_122012_().m_7494_(), true);
        dstWorld.m_46961_(returnPortalPos.m_122012_().m_7494_().m_7494_(), true);
        BlockState slabs = (BlockState)Blocks.f_50405_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
        dstWorld.m_7731_(returnPortalPos.m_122012_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos.m_122019_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos.m_122029_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos.m_122024_().m_7495_(), slabs, 3);
        dstWorld.m_7731_(returnPortalPos, (BlockState)UW_Registry.BLOCK_PORTAL_RETURN.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH), 3);
        BlockEntity te = dstWorld.m_7702_(returnPortalPos);
        if (null != te && te instanceof UW_PortalBlockEntity) {
            UW_PortalBlockEntity returnPortal = (UW_PortalBlockEntity)te;
            srcPortal.remoteDimensionId = dstWorld.m_46472_();
            srcPortal.remotePos = returnPortalPos;
            srcPortal.remoteDir = (byte)Direction.NORTH.ordinal();
            srcPortal.m_6596_();
            returnPortal.remoteDimensionId = srcPortal.localDimensionId;
            returnPortal.remotePos = new BlockPos((Vec3i)srcPortal.localPos);
            returnPortal.remoteDir = srcPortal.localDir;
            returnPortal.localDimensionId = srcPortal.remoteDimensionId;
            returnPortal.localPos = returnPortalPos;
            returnPortal.localDir = (byte)Direction.NORTH.ordinal();
            returnPortal.isReturnPortal = true;
            returnPortal.m_142339_((Level)dstWorld);
            returnPortal.m_6596_();
        } else {
            UW_Log.error("No return portal block entity found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rt) {
        if (!world.f_46443_) {
            BlockEntity be = world.m_7702_(pos);
            if (null != be && be instanceof UW_PortalBlockEntity && null != player) {
                UW_PortalBlockEntity portal = (UW_PortalBlockEntity)be;
                if (null == portal.localDimensionId) {
                    UW_Log.error("Portal tile entity invalid, localDimensionId is null.");
                    return InteractionResult.PASS;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (serverPlayer.m_6047_() && null == portal.remoteDimensionId && serverPlayer.m_7500_()) {
                        ArrayList<String> dimNames = new ArrayList<String>();
                        ArrayList<BlockPos> portalPos = new ArrayList<BlockPos>();
                        Iterable levels = world.m_7654_().m_129785_();
                        for (Level level : levels) {
                            Integer dimensionId;
                            if (level.m_46472_() == portal.localDimensionId || null == (dimensionId = UW_Utils.getDimensionId((ResourceKey<Level>)level.m_46472_())) && !UW_Utils.dimensionNameMap.containsKey(level.m_46472_().m_135782_().m_135815_())) continue;
                            dimNames.add(level.m_46472_().m_135782_().toString());
                            if (null != dimensionId) {
                                portalPos.add(UW_Utils.getDimensionReturnPortalPos((ServerLevel)level));
                                continue;
                            }
                            portalPos.add(new BlockPos(0, 0, 0));
                        }
                        UtilityWorlds.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new UW_Messages.MsgLinkGUI(dimNames.size(), portal.localDimensionId.m_135782_().toString(), portal.localPos, portal.localDir, dimNames, portalPos));
                        return InteractionResult.SUCCESS;
                    }
                    ServerLevel remoteDimension = null;
                    if (null == portal.remoteDimensionId && !(this instanceof UW_PortalBlockReturn)) {
                        UW_DimensionType type = this.getDimensionType();
                        ResourceKey<Level> dimensionKey = null;
                        Class<UtilityWorlds> clazz = UtilityWorlds.class;
                        synchronized (UtilityWorlds.class) {
                            dimensionKey = UW_Utils.getNextDimensionId(world, type);
                            // ** MonitorExit[var13_17] (shouldn't be in output)
                            try {
                                remoteDimension = UW_DimensionManager.createDimension(type, ((ServerLevel)world).m_7654_(), dimensionKey);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                                UW_Log.error("Exception creating dimension:", e);
                                return InteractionResult.SUCCESS;
                            }
                            ServerLevel localDimension = (ServerLevel)world;
                            if (null != localDimension && null != remoteDimension) {
                                UW_PortalBlock.createReturnPortal(localDimension, portal, remoteDimension, null);
                            }
                        }
                    } else if (null != portal.remoteDimensionId) {
                        remoteDimension = world.m_7654_().m_129880_(portal.remoteDimensionId);
                        remoteDimension.m_46745_(portal.remotePos);
                    }
                    {
                        if (null != remoteDimension) {
                            ServerLevel finalRemoteDimension = remoteDimension;
                            if (remoteDimension.m_46472_().m_135782_().m_135827_().equals("utilityworlds")) {
                                remoteDimension.m_8606_(Integer.MAX_VALUE, 0, false, false);
                            }
                            serverPlayer.m_20194_().execute(() -> {
                                Direction localDirection = Direction.values()[portal.localDir];
                                Direction remoteDirection = Direction.values()[portal.remoteDir];
                                Vec3 localPosition = UW_Utils.getTargetPlayerPos(portal.localPos, localDirection);
                                Vec3 remotePosition = UW_Utils.getTargetPlayerPos(portal.remotePos, remoteDirection);
                                UW_Log.debug("Teleporting player '" + serverPlayer.m_5446_().getString() + "' to dimension '" + finalRemoteDimension.m_46472_().m_135782_().m_135815_() + "' " + remotePosition.toString());
                                ChunkPos chunkpos = new ChunkPos(BlockPos.m_274561_((double)remotePosition.f_82479_, (double)remotePosition.f_82480_, (double)remotePosition.f_82481_));
                                finalRemoteDimension.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)serverPlayer.m_19879_());
                                this.teleport(serverPlayer, finalRemoteDimension, remotePosition, remoteDirection.m_122435_(), localPosition);
                            });
                        } else {
                            UW_Log.error("use: remoteDimension is null!");
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                UW_Log.error("use: Unexpected values: be = " + be + ", player = " + player);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.CONSUME;
    }

    private void teleport(ServerPlayer player, ServerLevel newLevel, Vec3 dstLoc, float dstDir, Vec3 srcLoc) {
        ServerLevel oldLevel = player.m_9236_();
        player.m_8127_();
        oldLevel.m_214150_(null, srcLoc.f_82479_, srcLoc.f_82480_, srcLoc.f_82481_, UW_Registry.PORTAL_SOUND, SoundSource.BLOCKS, 1.5f, 1.0f, 0L);
        player.changeDimension(newLevel, (ITeleporter)new UW_Teleporter(dstLoc, dstDir));
        newLevel.m_214150_(null, dstLoc.f_82479_, dstLoc.f_82480_, dstLoc.f_82481_, UW_Registry.PORTAL_SOUND, SoundSource.BLOCKS, 1.5f, 1.0f, 0L);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack itemStack) {
        Direction direction = null;
        if (entity != null) {
            direction = Direction.m_122364_((double)entity.f_19859_).m_122424_();
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction), 3);
        }
        if (!world.f_46443_) {
            ServerLevel localDimension = (ServerLevel)world;
            UW_PortalBlockEntity portal = (UW_PortalBlockEntity)localDimension.m_7702_(pos);
            if (null != portal) {
                ResourceKey localDimensionId = localDimension.m_46472_();
                boolean invalid_location = false;
                ArrayList<FormattedText> components = new ArrayList<FormattedText>();
                if (null != portal.isReturnPortal && portal.isReturnPortal.booleanValue() && localDimensionId != portal.localDimensionId) {
                    invalid_location = true;
                    String dimensionName = portal.localDimensionId.m_135782_().m_135815_();
                    components.add(FormattedText.m_130775_((String)(ChatFormatting.RED + "This portal can only be placed in dimension " + dimensionName + "." + ChatFormatting.RESET)));
                }
                if (portal.remoteDimensionId != null && portal.remoteDimensionId == localDimensionId) {
                    invalid_location = true;
                    components.add(FormattedText.m_130775_((String)(ChatFormatting.RED + "A portal cannot be placed in the target dimension." + ChatFormatting.RESET)));
                }
                if (invalid_location) {
                    itemStack.m_41764_(0);
                    List drops = Block.m_49869_((BlockState)portal.m_58900_(), (ServerLevel)localDimension, (BlockPos)pos, (BlockEntity)portal);
                    localDimension.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.m_36176_((ItemStack)drops.get(0), true);
                        for (FormattedText component : components) {
                            player.m_213846_((Component)Component.m_237113_((String)component.getString()));
                        }
                    }
                    return;
                }
                portal.localDimensionId = localDimension.m_46472_();
                if (null != entity && entity.m_6047_()) {
                    if (null != portal.nameOverride && entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.m_213846_((Component)Component.m_237113_((String)FormattedText.m_130775_((String)(ChatFormatting.AQUA + "Cleared portal custom name \"" + portal.nameOverride + "\"." + ChatFormatting.RESET)).getString()));
                    }
                    portal.nameOverride = null;
                } else if (itemStack.m_41788_()) {
                    portal.nameOverride = itemStack.m_41786_().getString();
                }
                portal.localPos = new BlockPos((Vec3i)pos);
                portal.localDir = (byte)direction.ordinal();
                portal.m_142339_((Level)localDimension);
                portal.m_6596_();
                if (null != portal.remoteDimensionId) {
                    ServerLevel remoteDimension = localDimension.m_7654_().m_129880_(portal.remoteDimensionId);
                    boolean remoteUpdated = false;
                    UW_PortalBlockEntity remotePortal = null;
                    if (null != remoteDimension && null != (remotePortal = (UW_PortalBlockEntity)remoteDimension.m_7702_(portal.remotePos))) {
                        remotePortal.remoteDimensionId = localDimension.m_46472_();
                        remotePortal.remotePos = new BlockPos((Vec3i)portal.localPos);
                        remotePortal.remoteDir = portal.localDir;
                        remotePortal.m_6596_();
                        remoteUpdated = true;
                    }
                    if (!remoteUpdated) {
                        UW_Log.error("Failed to update remote portal. remoteWorld = " + (Level)remoteDimension + ", remotePortal = " + remotePortal + ".");
                    }
                }
            } else {
                UW_Log.error("setPlacedBy: Portal block entity is null!");
            }
        }
    }
}

