/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import zarkov.utilityworlds.chunkgen.UW_ChunkGenerator;

public class UW_ChunkGeneratorGarden
extends UW_ChunkGenerator {
    public static final Codec<UW_ChunkGeneratorGarden> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_254866_((ResourceKey)Biomes.f_48202_)).apply((Applicative)instance, instance.stable(UW_ChunkGeneratorGarden::new)));
    private static final List<ResourceKey<PlacedFeature>> features = List.of(VegetationPlacements.f_195421_, VegetationPlacements.f_195415_, VegetationPlacements.f_195467_, VegetationPlacements.f_197412_, VegetationPlacements.f_195451_, VegetationPlacements.f_195406_, VegetationPlacements.f_195407_);
    private final WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));

    public UW_ChunkGeneratorGarden(Holder.Reference<Biome> biomeHolder) {
        super((BiomeSource)new FixedBiomeSource(biomeHolder));
    }

    public void m_214194_(WorldGenRegion p_223050_, StructureManager p_223051_, RandomState p_223052_, ChunkAccess chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, 0, z), this.bedrock, false);
                for (int y = 1; y < 5; ++y) {
                    chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, y, z), this.dirt, false);
                }
                chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, 5, z), this.grass, false);
            }
        }
    }

    public void m_213609_(WorldGenLevel level, ChunkAccess chunk, StructureManager sfManager) {
        ChunkPos chunkpos = chunk.m_7697_();
        SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)chunk.m_151560_());
        BlockPos blockpos = sectionpos.m_123249_();
        long seed = this.worldgenRandom.m_64690_(level.m_7328_(), blockpos.m_123341_(), blockpos.m_123343_());
        int featureIndex = 0;
        int featureSetIndex = 0;
        Registry registry = level.m_9598_().m_175515_(Registries.f_256988_);
        for (ResourceKey<PlacedFeature> featureHolder : features) {
            PlacedFeature placedFeature = (PlacedFeature)registry.m_6246_(featureHolder);
            this.worldgenRandom.m_190064_(seed, ++featureIndex, featureSetIndex);
            Supplier<String> genSupplier = () -> registry.m_7854_((Object)placedFeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedFeature).toString());
            level.m_143497_(genSupplier);
            Stream<Object> stream = Stream.of(blockpos);
            PlacementContext context = new PlacementContext(level, (ChunkGenerator)this, Optional.of(placedFeature));
            for (PlacementModifier placementModifier : placedFeature.f_191776_()) {
                if (placementModifier.m_183327_() == BiomeFilter.m_191561_().m_183327_()) continue;
                stream = stream.flatMap(blockPos -> placementModifier.m_213676_(context, (RandomSource)this.worldgenRandom, blockPos));
            }
            ConfiguredFeature configuredFeature = (ConfiguredFeature)placedFeature.f_191775_().m_203334_();
            stream.forEach(blockPos -> configuredFeature.m_224953_(context.m_191831_(), context.m_191833_(), (RandomSource)this.worldgenRandom, blockPos));
            ++featureSetIndex;
        }
        level.m_143497_(null);
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_223133_(Holder<Biome> p_204386_, StructureManager p_204387_, MobCategory p_204388_, BlockPos p_204389_) {
        return WeightedRandomList.m_146332_();
    }

    public int m_6337_() {
        return 0;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public int m_142062_() {
        return 0;
    }
}

