/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import zarkov.utilityworlds.chunkgen.UW_ChunkGenerator;
import zarkov.utilityworlds.config.UW_Config;

public class UW_ChunkGeneratorMining
extends UW_ChunkGenerator {
    private final Biome biome;
    static final int floorLevel = (Integer)UW_Config.MINING_DIMENSION_FLOOR.get();
    public static final Codec<UW_ChunkGeneratorMining> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_254866_((ResourceKey)Biomes.f_186765_)).apply((Applicative)instance, instance.stable(UW_ChunkGeneratorMining::new)));
    private final WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
    private final WorldgenRandom worldgenSlateRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));

    public UW_ChunkGeneratorMining(Holder.Reference<Biome> biomeHolder) {
        super((BiomeSource)new FixedBiomeSource(biomeHolder));
        this.biome = (Biome)biomeHolder.get();
    }

    public void m_214194_(WorldGenRegion p_223050_, StructureManager p_223051_, RandomState p_223052_, ChunkAccess chunk) {
        boolean gradient = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, floorLevel, z), this.bedrock, false);
                for (y = floorLevel + 1; y < 10; ++y) {
                    gradient = this.slateGradient(y, 0, 8);
                    chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, y, z), gradient ? this.deepslate : this.stone, false);
                }
                for (y = 10; y < 61; ++y) {
                    chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, y, z), this.stone, false);
                }
                for (y = 61; y < 63; ++y) {
                    chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, y, z), this.dirt, false);
                }
                chunk.m_6978_((BlockPos)this.blockPos.m_122178_(x, 63, z), this.grass, false);
            }
        }
    }

    private boolean slateGradient(int y, int lower, int upper) {
        int k = y;
        if ((Integer)UW_Config.MINING_DIMENSION_FLOOR.get() == 0) {
            return false;
        }
        if (k <= lower) {
            return true;
        }
        if (k >= upper) {
            return false;
        }
        double d0 = Mth.m_144914_((double)k, (double)lower, (double)upper, (double)1.0, (double)0.0);
        return this.worldgenSlateRandom.m_188500_() < d0;
    }

    public int m_142051_(LevelHeightAccessor p_156157_) {
        return 64;
    }

    public void m_213609_(WorldGenLevel level, ChunkAccess chunk, StructureManager sfManager) {
        ChunkPos chunkpos = chunk.m_7697_();
        SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)chunk.m_151560_());
        BlockPos blockpos = sectionpos.m_123249_();
        long seed = this.worldgenRandom.m_64690_(level.m_7328_(), blockpos.m_123341_(), blockpos.m_123343_());
        int featureIndex = 0;
        int featureSetIndex = 0;
        Registry registry = level.m_9598_().m_175515_(Registries.f_256988_);
        for (HolderSet featureHolderSet : this.biome.m_47536_().m_47818_()) {
            for (Holder featureHolder : featureHolderSet) {
                PlacedFeature placedFeature = (PlacedFeature)featureHolder.m_203334_();
                this.worldgenRandom.m_190064_(seed, ++featureIndex, featureSetIndex);
                Supplier<String> genSupplier = () -> registry.m_7854_((Object)placedFeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedFeature).toString());
                boolean place = true;
                Iterator iterator = ((ConfiguredFeature)placedFeature.f_191775_().m_203334_()).m_65398_().iterator();
                while (iterator.hasNext()) {
                    ConfiguredFeature next = (ConfiguredFeature)iterator.next();
                    if (!(next.f_65377_() instanceof LakeFeature)) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                level.m_143497_(genSupplier);
                Stream<Object> stream = Stream.of(blockpos);
                PlacementContext context = new PlacementContext(level, (ChunkGenerator)this, Optional.of(placedFeature));
                for (PlacementModifier placementModifier : placedFeature.f_191776_()) {
                    if (placementModifier.m_183327_() == BiomeFilter.m_191561_().m_183327_()) continue;
                    stream = stream.flatMap(blockPos -> placementModifier.m_213676_(context, (RandomSource)this.worldgenRandom, blockPos));
                }
                ConfiguredFeature configuredFeature = (ConfiguredFeature)placedFeature.f_191775_().m_203334_();
                stream.forEach(blockPos -> configuredFeature.m_224953_(context.m_191831_(), context.m_191833_(), (RandomSource)this.worldgenRandom, blockPos));
            }
            ++featureSetIndex;
        }
        level.m_143497_(null);
    }

    @Override
    public int m_6331_() {
        return 128;
    }

    public int m_6337_() {
        return 63;
    }

    public int m_142062_() {
        return floorLevel;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }
}

