/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds.dimensions;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.chunkgen.UW_ChunkGenerator;
import zarkov.utilityworlds.dimensions.UW_DimensionType;

public class UW_DimensionManager {
    public static ServerLevel createDimension(UW_DimensionType dimensionType, MinecraftServer server, ResourceKey<Level> dimensionKey) throws SecurityException, NoSuchFieldException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        HashMap<ResourceKey, MappedRegistry> newmap;
        Map map = server.forgeGetWorldMap();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ChunkProgressListener chunkProgressListener = server.f_129756_.m_9620_(11);
        Executor executor = server.f_129738_;
        LevelStorageSource.LevelStorageAccess anvilConverter = server.f_129744_;
        WorldData worldData = server.m_129910_();
        WorldOptions worldGenSettings = worldData.m_246337_();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.m_5996_());
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        Holder.Reference typeHolder = registryAccess.m_175515_(Registries.f_256787_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("utilityworlds", dimensionType.name)));
        Registry biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        Holder.Reference biomeHolder = dimensionType == UW_DimensionType.miningDimension ? (Holder.Reference)biomeRegistry.m_203636_(Biomes.f_186765_).get() : (Holder.Reference)biomeRegistry.m_203636_(Biomes.f_48202_).get();
        UW_ChunkGenerator chunkGenerator = dimensionType.chunkGenerator.getConstructor(Holder.Reference.class).newInstance(biomeHolder);
        LevelStem dimension = new LevelStem((Holder)typeHolder, (ChunkGenerator)chunkGenerator);
        LayeredRegistryAccess registries = server.m_247573_();
        RegistryAccess.ImmutableRegistryAccess composite = (RegistryAccess.ImmutableRegistryAccess)registries.m_247579_();
        HashMap<ResourceKey, MappedRegistry> regmap = new HashMap<ResourceKey, MappedRegistry>(composite.f_206223_);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("root")), (ResourceLocation)new ResourceLocation("dimension"));
        MappedRegistry oldRegistry = (MappedRegistry)regmap.get(key);
        Lifecycle oldLifecycle = oldRegistry.m_203658_();
        MappedRegistry newRegistry = new MappedRegistry(Registries.f_256862_, oldLifecycle, false);
        for (Map.Entry entry : oldRegistry.m_6579_()) {
            ResourceKey oldKey = (ResourceKey)entry.getKey();
            ResourceKey oldLevelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)oldKey.m_135782_());
            LevelStem dim = (LevelStem)entry.getValue();
            if (dim == null || oldLevelKey == dimensionKey) continue;
            Registry.m_194579_((Registry)newRegistry, (ResourceKey)oldKey, (Object)dim);
        }
        Registry.m_122965_((Registry)newRegistry, (ResourceLocation)dimensionKey.m_135782_(), (Object)dimension);
        regmap.replace(key, newRegistry);
        composite.f_206223_ = newmap = regmap;
        ServerLevel level = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)derivedLevelData, dimensionKey, dimension, chunkProgressListener, false, BiomeManager.m_47877_((long)worldGenSettings.m_245499_()), Collections.emptyList(), false);
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(level.m_6857_()));
        map.put(dimensionKey, level);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)level));
        UW_Log.info("Created new dimension with ID " + dimensionKey.toString());
        return level;
    }
}

